package io.fabric8.docker.api.model;

import javax.validation.Validation;
import io.fabric8.docker.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class ConfigBuilder extends ConfigFluentImpl<ConfigBuilder> implements VisitableBuilder<Config,ConfigBuilder>{

    ConfigFluent<?> fluent;
    Boolean validationEnabled;

    public ConfigBuilder(){
            this(true);
    }
    public ConfigBuilder(Boolean validationEnabled){
            this(new Config(), validationEnabled);
    }
    public ConfigBuilder(ConfigFluent<?> fluent){
            this(fluent, true);
    }
    public ConfigBuilder(ConfigFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Config(), validationEnabled);
    }
    public ConfigBuilder(ConfigFluent<?> fluent,Config instance){
            this(fluent, instance, true);
    }
    public ConfigBuilder(ConfigFluent<?> fluent,Config instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAttachStderr(instance.getAttachStderr()); 
            fluent.withAttachStdin(instance.getAttachStdin()); 
            fluent.withAttachStdout(instance.getAttachStdout()); 
            fluent.withCmd(instance.getCmd()); 
            fluent.withDomainname(instance.getDomainname()); 
            fluent.withEntrypoint(instance.getEntrypoint()); 
            fluent.withEnv(instance.getEnv()); 
            fluent.withExposedPorts(instance.getExposedPorts()); 
            fluent.withHostname(instance.getHostname()); 
            fluent.withImage(instance.getImage()); 
            fluent.withLabels(instance.getLabels()); 
            fluent.withMacAddress(instance.getMacAddress()); 
            fluent.withNetworkDisabled(instance.getNetworkDisabled()); 
            fluent.withOnBuild(instance.getOnBuild()); 
            fluent.withOpenStdin(instance.getOpenStdin()); 
            fluent.withPublishService(instance.getPublishService()); 
            fluent.withStdinOnce(instance.getStdinOnce()); 
            fluent.withStopSignal(instance.getStopSignal()); 
            fluent.withTty(instance.getTty()); 
            fluent.withUser(instance.getUser()); 
            fluent.withVolumes(instance.getVolumes()); 
            fluent.withWorkingDir(instance.getWorkingDir()); 
            this.validationEnabled = validationEnabled; 
    }
    public ConfigBuilder(Config instance){
            this(instance,true);
    }
    public ConfigBuilder(Config instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAttachStderr(instance.getAttachStderr()); 
            this.withAttachStdin(instance.getAttachStdin()); 
            this.withAttachStdout(instance.getAttachStdout()); 
            this.withCmd(instance.getCmd()); 
            this.withDomainname(instance.getDomainname()); 
            this.withEntrypoint(instance.getEntrypoint()); 
            this.withEnv(instance.getEnv()); 
            this.withExposedPorts(instance.getExposedPorts()); 
            this.withHostname(instance.getHostname()); 
            this.withImage(instance.getImage()); 
            this.withLabels(instance.getLabels()); 
            this.withMacAddress(instance.getMacAddress()); 
            this.withNetworkDisabled(instance.getNetworkDisabled()); 
            this.withOnBuild(instance.getOnBuild()); 
            this.withOpenStdin(instance.getOpenStdin()); 
            this.withPublishService(instance.getPublishService()); 
            this.withStdinOnce(instance.getStdinOnce()); 
            this.withStopSignal(instance.getStopSignal()); 
            this.withTty(instance.getTty()); 
            this.withUser(instance.getUser()); 
            this.withVolumes(instance.getVolumes()); 
            this.withWorkingDir(instance.getWorkingDir()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.docker.api.model.EditableConfig build(){
            EditableConfig buildable = new EditableConfig(fluent.isAttachStderr(),fluent.isAttachStdin(),fluent.isAttachStdout(),fluent.getCmd(),fluent.getDomainname(),fluent.getEntrypoint(),fluent.getEnv(),fluent.getExposedPorts(),fluent.getHostname(),fluent.getImage(),fluent.getLabels(),fluent.getMacAddress(),fluent.isNetworkDisabled(),fluent.getOnBuild(),fluent.isOpenStdin(),fluent.getPublishService(),fluent.isStdinOnce(),fluent.getStopSignal(),fluent.isTty(),fluent.getUser(),fluent.getVolumes(),fluent.getWorkingDir());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ConfigBuilder that = (ConfigBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
