package io.fabric8.docker.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.Valid;
import io.fabric8.docker.api.builder.BaseFluent;
import java.lang.Long;
import java.lang.Object;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;

public class CPUUsageFluentImpl<A extends CPUUsageFluent<A>> extends io.fabric8.docker.api.builder.BaseFluent<A> implements CPUUsageFluent<A>{

    private List<Long> percpuUsage = new ArrayList<Long>();
    private Long totalUsage;
    private Long usageInKernelmode;
    private Long usageInUsermode;

    public CPUUsageFluentImpl(){
    }
    public CPUUsageFluentImpl(CPUUsage instance){
            this.withPercpuUsage(instance.getPercpuUsage()); 
            this.withTotalUsage(instance.getTotalUsage()); 
            this.withUsageInKernelmode(instance.getUsageInKernelmode()); 
            this.withUsageInUsermode(instance.getUsageInUsermode()); 
    }

    public A addToPercpuUsage(Long... items){
            for (Long item : items) {this.percpuUsage.add(item);} return (A)this;
    }

    public A removeFromPercpuUsage(Long... items){
            for (Long item : items) {this.percpuUsage.remove(item);} return (A)this;
    }

    public List<Long> getPercpuUsage(){
            return this.percpuUsage;
    }

    public A withPercpuUsage(List<Long> percpuUsage){
            this.percpuUsage.clear();
            if (percpuUsage != null) {for (Long item : percpuUsage){this.addToPercpuUsage(item);}} return (A) this;
    }

    public A withPercpuUsage(Long... percpuUsage){
            this.percpuUsage.clear(); if (percpuUsage != null) {for (Long item :percpuUsage){ this.addToPercpuUsage(item);}} return (A) this;
    }

    public Long getTotalUsage(){
            return this.totalUsage;
    }

    public A withTotalUsage(Long totalUsage){
            this.totalUsage=totalUsage; return (A) this;
    }

    public Long getUsageInKernelmode(){
            return this.usageInKernelmode;
    }

    public A withUsageInKernelmode(Long usageInKernelmode){
            this.usageInKernelmode=usageInKernelmode; return (A) this;
    }

    public Long getUsageInUsermode(){
            return this.usageInUsermode;
    }

    public A withUsageInUsermode(Long usageInUsermode){
            this.usageInUsermode=usageInUsermode; return (A) this;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            CPUUsageFluentImpl that = (CPUUsageFluentImpl) o;
            if (percpuUsage != null ? !percpuUsage.equals(that.percpuUsage) :that.percpuUsage != null) return false;
            if (totalUsage != null ? !totalUsage.equals(that.totalUsage) :that.totalUsage != null) return false;
            if (usageInKernelmode != null ? !usageInKernelmode.equals(that.usageInKernelmode) :that.usageInKernelmode != null) return false;
            if (usageInUsermode != null ? !usageInUsermode.equals(that.usageInUsermode) :that.usageInUsermode != null) return false;
            return true;
    }




}
