package io.fabric8.docker.api.model;

import javax.validation.Validation;
import io.fabric8.docker.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class CPUUsageBuilder extends CPUUsageFluentImpl<CPUUsageBuilder> implements VisitableBuilder<CPUUsage,CPUUsageBuilder>{

    CPUUsageFluent<?> fluent;
    Boolean validationEnabled;

    public CPUUsageBuilder(){
            this(true);
    }
    public CPUUsageBuilder(Boolean validationEnabled){
            this(new CPUUsage(), validationEnabled);
    }
    public CPUUsageBuilder(CPUUsageFluent<?> fluent){
            this(fluent, true);
    }
    public CPUUsageBuilder(CPUUsageFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new CPUUsage(), validationEnabled);
    }
    public CPUUsageBuilder(CPUUsageFluent<?> fluent,CPUUsage instance){
            this(fluent, instance, true);
    }
    public CPUUsageBuilder(CPUUsageFluent<?> fluent,CPUUsage instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withPercpuUsage(instance.getPercpuUsage()); 
            fluent.withTotalUsage(instance.getTotalUsage()); 
            fluent.withUsageInKernelmode(instance.getUsageInKernelmode()); 
            fluent.withUsageInUsermode(instance.getUsageInUsermode()); 
            this.validationEnabled = validationEnabled; 
    }
    public CPUUsageBuilder(CPUUsage instance){
            this(instance,true);
    }
    public CPUUsageBuilder(CPUUsage instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withPercpuUsage(instance.getPercpuUsage()); 
            this.withTotalUsage(instance.getTotalUsage()); 
            this.withUsageInKernelmode(instance.getUsageInKernelmode()); 
            this.withUsageInUsermode(instance.getUsageInUsermode()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.docker.api.model.EditableCPUUsage build(){
            EditableCPUUsage buildable = new EditableCPUUsage(fluent.getPercpuUsage(),fluent.getTotalUsage(),fluent.getUsageInKernelmode(),fluent.getUsageInUsermode());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            CPUUsageBuilder that = (CPUUsageBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
