package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.docker.api.builder.Nested;
import io.fabric8.docker.api.builder.BaseFluent;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.Valid;
import java.lang.Long;
import java.lang.Object;
import lombok.ToString;

public class CPUStatsFluentImpl<A extends CPUStatsFluent<A>> extends io.fabric8.docker.api.builder.BaseFluent<A> implements CPUStatsFluent<A>{

    private VisitableBuilder<? extends CPUUsage,?> cpuUsage;
    private Long systemCpuUsage;
    private VisitableBuilder<? extends ThrottlingData,?> throttlingData;

    public CPUStatsFluentImpl(){
    }
    public CPUStatsFluentImpl(CPUStats instance){
            this.withCpuUsage(instance.getCpuUsage()); 
            this.withSystemCpuUsage(instance.getSystemCpuUsage()); 
            this.withThrottlingData(instance.getThrottlingData()); 
    }

    public CPUUsage getCpuUsage(){
            return this.cpuUsage!=null?this.cpuUsage.build():null;
    }

    public A withCpuUsage(CPUUsage cpuUsage){
            _visitables.remove(this.cpuUsage);
            if (cpuUsage!=null){ this.cpuUsage= new CPUUsageBuilder(cpuUsage); _visitables.add(this.cpuUsage);} return (A) this;
    }

    public CPUStatsFluent.CpuUsageNested<A> withNewCpuUsage(){
            return new CpuUsageNestedImpl();
    }

    public CPUStatsFluent.CpuUsageNested<A> withNewCpuUsageLike(CPUUsage item){
            return new CpuUsageNestedImpl(item);
    }

    public CPUStatsFluent.CpuUsageNested<A> editCpuUsage(){
            return withNewCpuUsageLike(getCpuUsage());
    }

    public CPUStatsFluent.CpuUsageNested<A> editOrNewCpuUsage(){
            return withNewCpuUsageLike(getCpuUsage() != null ? getCpuUsage(): new CPUUsageBuilder().build());
    }

    public CPUStatsFluent.CpuUsageNested<A> editOrNewCpuUsageLike(CPUUsage item){
            return withNewCpuUsageLike(getCpuUsage() != null ? getCpuUsage(): item);
    }

    public Long getSystemCpuUsage(){
            return this.systemCpuUsage;
    }

    public A withSystemCpuUsage(Long systemCpuUsage){
            this.systemCpuUsage=systemCpuUsage; return (A) this;
    }

    public ThrottlingData getThrottlingData(){
            return this.throttlingData!=null?this.throttlingData.build():null;
    }

    public A withThrottlingData(ThrottlingData throttlingData){
            _visitables.remove(this.throttlingData);
            if (throttlingData!=null){ this.throttlingData= new ThrottlingDataBuilder(throttlingData); _visitables.add(this.throttlingData);} return (A) this;
    }

    public CPUStatsFluent.ThrottlingDataNested<A> withNewThrottlingData(){
            return new ThrottlingDataNestedImpl();
    }

    public CPUStatsFluent.ThrottlingDataNested<A> withNewThrottlingDataLike(ThrottlingData item){
            return new ThrottlingDataNestedImpl(item);
    }

    public CPUStatsFluent.ThrottlingDataNested<A> editThrottlingData(){
            return withNewThrottlingDataLike(getThrottlingData());
    }

    public CPUStatsFluent.ThrottlingDataNested<A> editOrNewThrottlingData(){
            return withNewThrottlingDataLike(getThrottlingData() != null ? getThrottlingData(): new ThrottlingDataBuilder().build());
    }

    public CPUStatsFluent.ThrottlingDataNested<A> editOrNewThrottlingDataLike(ThrottlingData item){
            return withNewThrottlingDataLike(getThrottlingData() != null ? getThrottlingData(): item);
    }

    public A withNewThrottlingData(Long periods,Long throttledPeriods,Long throttledTime){
            return (A)withThrottlingData(new ThrottlingData(periods, throttledPeriods, throttledTime));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            CPUStatsFluentImpl that = (CPUStatsFluentImpl) o;
            if (cpuUsage != null ? !cpuUsage.equals(that.cpuUsage) :that.cpuUsage != null) return false;
            if (systemCpuUsage != null ? !systemCpuUsage.equals(that.systemCpuUsage) :that.systemCpuUsage != null) return false;
            if (throttlingData != null ? !throttlingData.equals(that.throttlingData) :that.throttlingData != null) return false;
            return true;
    }


    public class CpuUsageNestedImpl<N> extends CPUUsageFluentImpl<CPUStatsFluent.CpuUsageNested<N>> implements CPUStatsFluent.CpuUsageNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final CPUUsageBuilder builder;
    
            CpuUsageNestedImpl(CPUUsage item){
                    this.builder = new CPUUsageBuilder(this, item);
            }
            CpuUsageNestedImpl(){
                    this.builder = new CPUUsageBuilder(this);
            }
    
    public N and(){
            return (N) CPUStatsFluentImpl.this.withCpuUsage(builder.build());
    }
    public N endCpuUsage(){
            return and();
    }

}
    public class ThrottlingDataNestedImpl<N> extends ThrottlingDataFluentImpl<CPUStatsFluent.ThrottlingDataNested<N>> implements CPUStatsFluent.ThrottlingDataNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final ThrottlingDataBuilder builder;
    
            ThrottlingDataNestedImpl(ThrottlingData item){
                    this.builder = new ThrottlingDataBuilder(this, item);
            }
            ThrottlingDataNestedImpl(){
                    this.builder = new ThrottlingDataBuilder(this);
            }
    
    public N and(){
            return (N) CPUStatsFluentImpl.this.withThrottlingData(builder.build());
    }
    public N endThrottlingData(){
            return and();
    }

}


}
