package io.fabric8.docker.api.model;

import javax.validation.Validation;
import io.fabric8.docker.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class CPUStatsBuilder extends CPUStatsFluentImpl<CPUStatsBuilder> implements VisitableBuilder<CPUStats,CPUStatsBuilder>{

    CPUStatsFluent<?> fluent;
    Boolean validationEnabled;

    public CPUStatsBuilder(){
            this(true);
    }
    public CPUStatsBuilder(Boolean validationEnabled){
            this(new CPUStats(), validationEnabled);
    }
    public CPUStatsBuilder(CPUStatsFluent<?> fluent){
            this(fluent, true);
    }
    public CPUStatsBuilder(CPUStatsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new CPUStats(), validationEnabled);
    }
    public CPUStatsBuilder(CPUStatsFluent<?> fluent,CPUStats instance){
            this(fluent, instance, true);
    }
    public CPUStatsBuilder(CPUStatsFluent<?> fluent,CPUStats instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withCpuUsage(instance.getCpuUsage()); 
            fluent.withSystemCpuUsage(instance.getSystemCpuUsage()); 
            fluent.withThrottlingData(instance.getThrottlingData()); 
            this.validationEnabled = validationEnabled; 
    }
    public CPUStatsBuilder(CPUStats instance){
            this(instance,true);
    }
    public CPUStatsBuilder(CPUStats instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withCpuUsage(instance.getCpuUsage()); 
            this.withSystemCpuUsage(instance.getSystemCpuUsage()); 
            this.withThrottlingData(instance.getThrottlingData()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.docker.api.model.EditableCPUStats build(){
            EditableCPUStats buildable = new EditableCPUStats(fluent.getCpuUsage(),fluent.getSystemCpuUsage(),fluent.getThrottlingData());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            CPUStatsBuilder that = (CPUStatsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
