package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.docker.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.docker.api.builder.BaseFluent;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.Valid;
import java.lang.Long;
import java.lang.Object;
import lombok.ToString;

public class BlkioStatsFluentImpl<A extends BlkioStatsFluent<A>> extends io.fabric8.docker.api.builder.BaseFluent<A> implements BlkioStatsFluent<A>{

    private List<VisitableBuilder<? extends BlkioStatEntry,?>> ioMergedRecursive =  new ArrayList<VisitableBuilder<? extends BlkioStatEntry,?>>();
    private List<VisitableBuilder<? extends BlkioStatEntry,?>> ioQueueRecursive =  new ArrayList<VisitableBuilder<? extends BlkioStatEntry,?>>();
    private List<VisitableBuilder<? extends BlkioStatEntry,?>> ioServiceBytesRecursive =  new ArrayList<VisitableBuilder<? extends BlkioStatEntry,?>>();
    private List<VisitableBuilder<? extends BlkioStatEntry,?>> ioServiceTimeRecursive =  new ArrayList<VisitableBuilder<? extends BlkioStatEntry,?>>();
    private List<VisitableBuilder<? extends BlkioStatEntry,?>> ioServicedRecursive =  new ArrayList<VisitableBuilder<? extends BlkioStatEntry,?>>();
    private List<VisitableBuilder<? extends BlkioStatEntry,?>> ioTimeRecursive =  new ArrayList<VisitableBuilder<? extends BlkioStatEntry,?>>();
    private List<VisitableBuilder<? extends BlkioStatEntry,?>> ioWaitTimeRecursive =  new ArrayList<VisitableBuilder<? extends BlkioStatEntry,?>>();
    private List<VisitableBuilder<? extends BlkioStatEntry,?>> sectorsRecursive =  new ArrayList<VisitableBuilder<? extends BlkioStatEntry,?>>();

    public BlkioStatsFluentImpl(){
    }
    public BlkioStatsFluentImpl(BlkioStats instance){
            this.withIoMergedRecursive(instance.getIoMergedRecursive()); 
            this.withIoQueueRecursive(instance.getIoQueueRecursive()); 
            this.withIoServiceBytesRecursive(instance.getIoServiceBytesRecursive()); 
            this.withIoServiceTimeRecursive(instance.getIoServiceTimeRecursive()); 
            this.withIoServicedRecursive(instance.getIoServicedRecursive()); 
            this.withIoTimeRecursive(instance.getIoTimeRecursive()); 
            this.withIoWaitTimeRecursive(instance.getIoWaitTimeRecursive()); 
            this.withSectorsRecursive(instance.getSectorsRecursive()); 
    }

    public A addToIoMergedRecursive(BlkioStatEntry... items){
            for (BlkioStatEntry item : items) {BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);_visitables.add(builder);this.ioMergedRecursive.add(builder);} return (A)this;
    }

    public A removeFromIoMergedRecursive(BlkioStatEntry... items){
            for (BlkioStatEntry item : items) {BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);_visitables.remove(builder);this.ioMergedRecursive.remove(builder);} return (A)this;
    }

    public List<BlkioStatEntry> getIoMergedRecursive(){
            return build(ioMergedRecursive);
    }

    public A withIoMergedRecursive(List<BlkioStatEntry> ioMergedRecursive){
            _visitables.removeAll(this.ioMergedRecursive);
            this.ioMergedRecursive.clear();
            if (ioMergedRecursive != null) {for (BlkioStatEntry item : ioMergedRecursive){this.addToIoMergedRecursive(item);}} return (A) this;
    }

    public A withIoMergedRecursive(BlkioStatEntry... ioMergedRecursive){
            this.ioMergedRecursive.clear(); if (ioMergedRecursive != null) {for (BlkioStatEntry item :ioMergedRecursive){ this.addToIoMergedRecursive(item);}} return (A) this;
    }

    public BlkioStatsFluent.IoMergedRecursiveNested<A> addNewIoMergedRecursive(){
            return new IoMergedRecursiveNestedImpl();
    }

    public BlkioStatsFluent.IoMergedRecursiveNested<A> addNewIoMergedRecursiveLike(BlkioStatEntry item){
            return new IoMergedRecursiveNestedImpl(item);
    }

    public A addNewIoMergedRecursive(Long major,Long minor,String op,Long value){
            return (A)addToIoMergedRecursive(new BlkioStatEntry(major, minor, op, value));
    }

    public A addToIoQueueRecursive(BlkioStatEntry... items){
            for (BlkioStatEntry item : items) {BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);_visitables.add(builder);this.ioQueueRecursive.add(builder);} return (A)this;
    }

    public A removeFromIoQueueRecursive(BlkioStatEntry... items){
            for (BlkioStatEntry item : items) {BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);_visitables.remove(builder);this.ioQueueRecursive.remove(builder);} return (A)this;
    }

    public List<BlkioStatEntry> getIoQueueRecursive(){
            return build(ioQueueRecursive);
    }

    public A withIoQueueRecursive(List<BlkioStatEntry> ioQueueRecursive){
            _visitables.removeAll(this.ioQueueRecursive);
            this.ioQueueRecursive.clear();
            if (ioQueueRecursive != null) {for (BlkioStatEntry item : ioQueueRecursive){this.addToIoQueueRecursive(item);}} return (A) this;
    }

    public A withIoQueueRecursive(BlkioStatEntry... ioQueueRecursive){
            this.ioQueueRecursive.clear(); if (ioQueueRecursive != null) {for (BlkioStatEntry item :ioQueueRecursive){ this.addToIoQueueRecursive(item);}} return (A) this;
    }

    public BlkioStatsFluent.IoQueueRecursiveNested<A> addNewIoQueueRecursive(){
            return new IoQueueRecursiveNestedImpl();
    }

    public BlkioStatsFluent.IoQueueRecursiveNested<A> addNewIoQueueRecursiveLike(BlkioStatEntry item){
            return new IoQueueRecursiveNestedImpl(item);
    }

    public A addNewIoQueueRecursive(Long major,Long minor,String op,Long value){
            return (A)addToIoQueueRecursive(new BlkioStatEntry(major, minor, op, value));
    }

    public A addToIoServiceBytesRecursive(BlkioStatEntry... items){
            for (BlkioStatEntry item : items) {BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);_visitables.add(builder);this.ioServiceBytesRecursive.add(builder);} return (A)this;
    }

    public A removeFromIoServiceBytesRecursive(BlkioStatEntry... items){
            for (BlkioStatEntry item : items) {BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);_visitables.remove(builder);this.ioServiceBytesRecursive.remove(builder);} return (A)this;
    }

    public List<BlkioStatEntry> getIoServiceBytesRecursive(){
            return build(ioServiceBytesRecursive);
    }

    public A withIoServiceBytesRecursive(List<BlkioStatEntry> ioServiceBytesRecursive){
            _visitables.removeAll(this.ioServiceBytesRecursive);
            this.ioServiceBytesRecursive.clear();
            if (ioServiceBytesRecursive != null) {for (BlkioStatEntry item : ioServiceBytesRecursive){this.addToIoServiceBytesRecursive(item);}} return (A) this;
    }

    public A withIoServiceBytesRecursive(BlkioStatEntry... ioServiceBytesRecursive){
            this.ioServiceBytesRecursive.clear(); if (ioServiceBytesRecursive != null) {for (BlkioStatEntry item :ioServiceBytesRecursive){ this.addToIoServiceBytesRecursive(item);}} return (A) this;
    }

    public BlkioStatsFluent.IoServiceBytesRecursiveNested<A> addNewIoServiceBytesRecursive(){
            return new IoServiceBytesRecursiveNestedImpl();
    }

    public BlkioStatsFluent.IoServiceBytesRecursiveNested<A> addNewIoServiceBytesRecursiveLike(BlkioStatEntry item){
            return new IoServiceBytesRecursiveNestedImpl(item);
    }

    public A addNewIoServiceBytesRecursive(Long major,Long minor,String op,Long value){
            return (A)addToIoServiceBytesRecursive(new BlkioStatEntry(major, minor, op, value));
    }

    public A addToIoServiceTimeRecursive(BlkioStatEntry... items){
            for (BlkioStatEntry item : items) {BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);_visitables.add(builder);this.ioServiceTimeRecursive.add(builder);} return (A)this;
    }

    public A removeFromIoServiceTimeRecursive(BlkioStatEntry... items){
            for (BlkioStatEntry item : items) {BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);_visitables.remove(builder);this.ioServiceTimeRecursive.remove(builder);} return (A)this;
    }

    public List<BlkioStatEntry> getIoServiceTimeRecursive(){
            return build(ioServiceTimeRecursive);
    }

    public A withIoServiceTimeRecursive(List<BlkioStatEntry> ioServiceTimeRecursive){
            _visitables.removeAll(this.ioServiceTimeRecursive);
            this.ioServiceTimeRecursive.clear();
            if (ioServiceTimeRecursive != null) {for (BlkioStatEntry item : ioServiceTimeRecursive){this.addToIoServiceTimeRecursive(item);}} return (A) this;
    }

    public A withIoServiceTimeRecursive(BlkioStatEntry... ioServiceTimeRecursive){
            this.ioServiceTimeRecursive.clear(); if (ioServiceTimeRecursive != null) {for (BlkioStatEntry item :ioServiceTimeRecursive){ this.addToIoServiceTimeRecursive(item);}} return (A) this;
    }

    public BlkioStatsFluent.IoServiceTimeRecursiveNested<A> addNewIoServiceTimeRecursive(){
            return new IoServiceTimeRecursiveNestedImpl();
    }

    public BlkioStatsFluent.IoServiceTimeRecursiveNested<A> addNewIoServiceTimeRecursiveLike(BlkioStatEntry item){
            return new IoServiceTimeRecursiveNestedImpl(item);
    }

    public A addNewIoServiceTimeRecursive(Long major,Long minor,String op,Long value){
            return (A)addToIoServiceTimeRecursive(new BlkioStatEntry(major, minor, op, value));
    }

    public A addToIoServicedRecursive(BlkioStatEntry... items){
            for (BlkioStatEntry item : items) {BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);_visitables.add(builder);this.ioServicedRecursive.add(builder);} return (A)this;
    }

    public A removeFromIoServicedRecursive(BlkioStatEntry... items){
            for (BlkioStatEntry item : items) {BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);_visitables.remove(builder);this.ioServicedRecursive.remove(builder);} return (A)this;
    }

    public List<BlkioStatEntry> getIoServicedRecursive(){
            return build(ioServicedRecursive);
    }

    public A withIoServicedRecursive(List<BlkioStatEntry> ioServicedRecursive){
            _visitables.removeAll(this.ioServicedRecursive);
            this.ioServicedRecursive.clear();
            if (ioServicedRecursive != null) {for (BlkioStatEntry item : ioServicedRecursive){this.addToIoServicedRecursive(item);}} return (A) this;
    }

    public A withIoServicedRecursive(BlkioStatEntry... ioServicedRecursive){
            this.ioServicedRecursive.clear(); if (ioServicedRecursive != null) {for (BlkioStatEntry item :ioServicedRecursive){ this.addToIoServicedRecursive(item);}} return (A) this;
    }

    public BlkioStatsFluent.IoServicedRecursiveNested<A> addNewIoServicedRecursive(){
            return new IoServicedRecursiveNestedImpl();
    }

    public BlkioStatsFluent.IoServicedRecursiveNested<A> addNewIoServicedRecursiveLike(BlkioStatEntry item){
            return new IoServicedRecursiveNestedImpl(item);
    }

    public A addNewIoServicedRecursive(Long major,Long minor,String op,Long value){
            return (A)addToIoServicedRecursive(new BlkioStatEntry(major, minor, op, value));
    }

    public A addToIoTimeRecursive(BlkioStatEntry... items){
            for (BlkioStatEntry item : items) {BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);_visitables.add(builder);this.ioTimeRecursive.add(builder);} return (A)this;
    }

    public A removeFromIoTimeRecursive(BlkioStatEntry... items){
            for (BlkioStatEntry item : items) {BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);_visitables.remove(builder);this.ioTimeRecursive.remove(builder);} return (A)this;
    }

    public List<BlkioStatEntry> getIoTimeRecursive(){
            return build(ioTimeRecursive);
    }

    public A withIoTimeRecursive(List<BlkioStatEntry> ioTimeRecursive){
            _visitables.removeAll(this.ioTimeRecursive);
            this.ioTimeRecursive.clear();
            if (ioTimeRecursive != null) {for (BlkioStatEntry item : ioTimeRecursive){this.addToIoTimeRecursive(item);}} return (A) this;
    }

    public A withIoTimeRecursive(BlkioStatEntry... ioTimeRecursive){
            this.ioTimeRecursive.clear(); if (ioTimeRecursive != null) {for (BlkioStatEntry item :ioTimeRecursive){ this.addToIoTimeRecursive(item);}} return (A) this;
    }

    public BlkioStatsFluent.IoTimeRecursiveNested<A> addNewIoTimeRecursive(){
            return new IoTimeRecursiveNestedImpl();
    }

    public BlkioStatsFluent.IoTimeRecursiveNested<A> addNewIoTimeRecursiveLike(BlkioStatEntry item){
            return new IoTimeRecursiveNestedImpl(item);
    }

    public A addNewIoTimeRecursive(Long major,Long minor,String op,Long value){
            return (A)addToIoTimeRecursive(new BlkioStatEntry(major, minor, op, value));
    }

    public A addToIoWaitTimeRecursive(BlkioStatEntry... items){
            for (BlkioStatEntry item : items) {BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);_visitables.add(builder);this.ioWaitTimeRecursive.add(builder);} return (A)this;
    }

    public A removeFromIoWaitTimeRecursive(BlkioStatEntry... items){
            for (BlkioStatEntry item : items) {BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);_visitables.remove(builder);this.ioWaitTimeRecursive.remove(builder);} return (A)this;
    }

    public List<BlkioStatEntry> getIoWaitTimeRecursive(){
            return build(ioWaitTimeRecursive);
    }

    public A withIoWaitTimeRecursive(List<BlkioStatEntry> ioWaitTimeRecursive){
            _visitables.removeAll(this.ioWaitTimeRecursive);
            this.ioWaitTimeRecursive.clear();
            if (ioWaitTimeRecursive != null) {for (BlkioStatEntry item : ioWaitTimeRecursive){this.addToIoWaitTimeRecursive(item);}} return (A) this;
    }

    public A withIoWaitTimeRecursive(BlkioStatEntry... ioWaitTimeRecursive){
            this.ioWaitTimeRecursive.clear(); if (ioWaitTimeRecursive != null) {for (BlkioStatEntry item :ioWaitTimeRecursive){ this.addToIoWaitTimeRecursive(item);}} return (A) this;
    }

    public BlkioStatsFluent.IoWaitTimeRecursiveNested<A> addNewIoWaitTimeRecursive(){
            return new IoWaitTimeRecursiveNestedImpl();
    }

    public BlkioStatsFluent.IoWaitTimeRecursiveNested<A> addNewIoWaitTimeRecursiveLike(BlkioStatEntry item){
            return new IoWaitTimeRecursiveNestedImpl(item);
    }

    public A addNewIoWaitTimeRecursive(Long major,Long minor,String op,Long value){
            return (A)addToIoWaitTimeRecursive(new BlkioStatEntry(major, minor, op, value));
    }

    public A addToSectorsRecursive(BlkioStatEntry... items){
            for (BlkioStatEntry item : items) {BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);_visitables.add(builder);this.sectorsRecursive.add(builder);} return (A)this;
    }

    public A removeFromSectorsRecursive(BlkioStatEntry... items){
            for (BlkioStatEntry item : items) {BlkioStatEntryBuilder builder = new BlkioStatEntryBuilder(item);_visitables.remove(builder);this.sectorsRecursive.remove(builder);} return (A)this;
    }

    public List<BlkioStatEntry> getSectorsRecursive(){
            return build(sectorsRecursive);
    }

    public A withSectorsRecursive(List<BlkioStatEntry> sectorsRecursive){
            _visitables.removeAll(this.sectorsRecursive);
            this.sectorsRecursive.clear();
            if (sectorsRecursive != null) {for (BlkioStatEntry item : sectorsRecursive){this.addToSectorsRecursive(item);}} return (A) this;
    }

    public A withSectorsRecursive(BlkioStatEntry... sectorsRecursive){
            this.sectorsRecursive.clear(); if (sectorsRecursive != null) {for (BlkioStatEntry item :sectorsRecursive){ this.addToSectorsRecursive(item);}} return (A) this;
    }

    public BlkioStatsFluent.SectorsRecursiveNested<A> addNewSectorsRecursive(){
            return new SectorsRecursiveNestedImpl();
    }

    public BlkioStatsFluent.SectorsRecursiveNested<A> addNewSectorsRecursiveLike(BlkioStatEntry item){
            return new SectorsRecursiveNestedImpl(item);
    }

    public A addNewSectorsRecursive(Long major,Long minor,String op,Long value){
            return (A)addToSectorsRecursive(new BlkioStatEntry(major, minor, op, value));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            BlkioStatsFluentImpl that = (BlkioStatsFluentImpl) o;
            if (ioMergedRecursive != null ? !ioMergedRecursive.equals(that.ioMergedRecursive) :that.ioMergedRecursive != null) return false;
            if (ioQueueRecursive != null ? !ioQueueRecursive.equals(that.ioQueueRecursive) :that.ioQueueRecursive != null) return false;
            if (ioServiceBytesRecursive != null ? !ioServiceBytesRecursive.equals(that.ioServiceBytesRecursive) :that.ioServiceBytesRecursive != null) return false;
            if (ioServiceTimeRecursive != null ? !ioServiceTimeRecursive.equals(that.ioServiceTimeRecursive) :that.ioServiceTimeRecursive != null) return false;
            if (ioServicedRecursive != null ? !ioServicedRecursive.equals(that.ioServicedRecursive) :that.ioServicedRecursive != null) return false;
            if (ioTimeRecursive != null ? !ioTimeRecursive.equals(that.ioTimeRecursive) :that.ioTimeRecursive != null) return false;
            if (ioWaitTimeRecursive != null ? !ioWaitTimeRecursive.equals(that.ioWaitTimeRecursive) :that.ioWaitTimeRecursive != null) return false;
            if (sectorsRecursive != null ? !sectorsRecursive.equals(that.sectorsRecursive) :that.sectorsRecursive != null) return false;
            return true;
    }


    public class IoMergedRecursiveNestedImpl<N> extends BlkioStatEntryFluentImpl<BlkioStatsFluent.IoMergedRecursiveNested<N>> implements BlkioStatsFluent.IoMergedRecursiveNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final BlkioStatEntryBuilder builder;
    
            IoMergedRecursiveNestedImpl(BlkioStatEntry item){
                    this.builder = new BlkioStatEntryBuilder(this, item);
            }
            IoMergedRecursiveNestedImpl(){
                    this.builder = new BlkioStatEntryBuilder(this);
            }
    
    public N and(){
            return (N) BlkioStatsFluentImpl.this.addToIoMergedRecursive(builder.build());
    }
    public N endIoMergedRecursive(){
            return and();
    }

}
    public class IoQueueRecursiveNestedImpl<N> extends BlkioStatEntryFluentImpl<BlkioStatsFluent.IoQueueRecursiveNested<N>> implements BlkioStatsFluent.IoQueueRecursiveNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final BlkioStatEntryBuilder builder;
    
            IoQueueRecursiveNestedImpl(BlkioStatEntry item){
                    this.builder = new BlkioStatEntryBuilder(this, item);
            }
            IoQueueRecursiveNestedImpl(){
                    this.builder = new BlkioStatEntryBuilder(this);
            }
    
    public N and(){
            return (N) BlkioStatsFluentImpl.this.addToIoQueueRecursive(builder.build());
    }
    public N endIoQueueRecursive(){
            return and();
    }

}
    public class IoServiceBytesRecursiveNestedImpl<N> extends BlkioStatEntryFluentImpl<BlkioStatsFluent.IoServiceBytesRecursiveNested<N>> implements BlkioStatsFluent.IoServiceBytesRecursiveNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final BlkioStatEntryBuilder builder;
    
            IoServiceBytesRecursiveNestedImpl(BlkioStatEntry item){
                    this.builder = new BlkioStatEntryBuilder(this, item);
            }
            IoServiceBytesRecursiveNestedImpl(){
                    this.builder = new BlkioStatEntryBuilder(this);
            }
    
    public N and(){
            return (N) BlkioStatsFluentImpl.this.addToIoServiceBytesRecursive(builder.build());
    }
    public N endIoServiceBytesRecursive(){
            return and();
    }

}
    public class IoServiceTimeRecursiveNestedImpl<N> extends BlkioStatEntryFluentImpl<BlkioStatsFluent.IoServiceTimeRecursiveNested<N>> implements BlkioStatsFluent.IoServiceTimeRecursiveNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final BlkioStatEntryBuilder builder;
    
            IoServiceTimeRecursiveNestedImpl(BlkioStatEntry item){
                    this.builder = new BlkioStatEntryBuilder(this, item);
            }
            IoServiceTimeRecursiveNestedImpl(){
                    this.builder = new BlkioStatEntryBuilder(this);
            }
    
    public N and(){
            return (N) BlkioStatsFluentImpl.this.addToIoServiceTimeRecursive(builder.build());
    }
    public N endIoServiceTimeRecursive(){
            return and();
    }

}
    public class IoServicedRecursiveNestedImpl<N> extends BlkioStatEntryFluentImpl<BlkioStatsFluent.IoServicedRecursiveNested<N>> implements BlkioStatsFluent.IoServicedRecursiveNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final BlkioStatEntryBuilder builder;
    
            IoServicedRecursiveNestedImpl(BlkioStatEntry item){
                    this.builder = new BlkioStatEntryBuilder(this, item);
            }
            IoServicedRecursiveNestedImpl(){
                    this.builder = new BlkioStatEntryBuilder(this);
            }
    
    public N and(){
            return (N) BlkioStatsFluentImpl.this.addToIoServicedRecursive(builder.build());
    }
    public N endIoServicedRecursive(){
            return and();
    }

}
    public class IoTimeRecursiveNestedImpl<N> extends BlkioStatEntryFluentImpl<BlkioStatsFluent.IoTimeRecursiveNested<N>> implements BlkioStatsFluent.IoTimeRecursiveNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final BlkioStatEntryBuilder builder;
    
            IoTimeRecursiveNestedImpl(BlkioStatEntry item){
                    this.builder = new BlkioStatEntryBuilder(this, item);
            }
            IoTimeRecursiveNestedImpl(){
                    this.builder = new BlkioStatEntryBuilder(this);
            }
    
    public N and(){
            return (N) BlkioStatsFluentImpl.this.addToIoTimeRecursive(builder.build());
    }
    public N endIoTimeRecursive(){
            return and();
    }

}
    public class IoWaitTimeRecursiveNestedImpl<N> extends BlkioStatEntryFluentImpl<BlkioStatsFluent.IoWaitTimeRecursiveNested<N>> implements BlkioStatsFluent.IoWaitTimeRecursiveNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final BlkioStatEntryBuilder builder;
    
            IoWaitTimeRecursiveNestedImpl(BlkioStatEntry item){
                    this.builder = new BlkioStatEntryBuilder(this, item);
            }
            IoWaitTimeRecursiveNestedImpl(){
                    this.builder = new BlkioStatEntryBuilder(this);
            }
    
    public N and(){
            return (N) BlkioStatsFluentImpl.this.addToIoWaitTimeRecursive(builder.build());
    }
    public N endIoWaitTimeRecursive(){
            return and();
    }

}
    public class SectorsRecursiveNestedImpl<N> extends BlkioStatEntryFluentImpl<BlkioStatsFluent.SectorsRecursiveNested<N>> implements BlkioStatsFluent.SectorsRecursiveNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final BlkioStatEntryBuilder builder;
    
            SectorsRecursiveNestedImpl(BlkioStatEntry item){
                    this.builder = new BlkioStatEntryBuilder(this, item);
            }
            SectorsRecursiveNestedImpl(){
                    this.builder = new BlkioStatEntryBuilder(this);
            }
    
    public N and(){
            return (N) BlkioStatsFluentImpl.this.addToSectorsRecursive(builder.build());
    }
    public N endSectorsRecursive(){
            return and();
    }

}


}
