package io.fabric8.docker.api.model;

import javax.validation.Validation;
import io.fabric8.docker.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class BlkioStatEntryBuilder extends BlkioStatEntryFluentImpl<BlkioStatEntryBuilder> implements VisitableBuilder<BlkioStatEntry,BlkioStatEntryBuilder>{

    BlkioStatEntryFluent<?> fluent;
    Boolean validationEnabled;

    public BlkioStatEntryBuilder(){
            this(true);
    }
    public BlkioStatEntryBuilder(Boolean validationEnabled){
            this(new BlkioStatEntry(), validationEnabled);
    }
    public BlkioStatEntryBuilder(BlkioStatEntryFluent<?> fluent){
            this(fluent, true);
    }
    public BlkioStatEntryBuilder(BlkioStatEntryFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new BlkioStatEntry(), validationEnabled);
    }
    public BlkioStatEntryBuilder(BlkioStatEntryFluent<?> fluent,BlkioStatEntry instance){
            this(fluent, instance, true);
    }
    public BlkioStatEntryBuilder(BlkioStatEntryFluent<?> fluent,BlkioStatEntry instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withMajor(instance.getMajor()); 
            fluent.withMinor(instance.getMinor()); 
            fluent.withOp(instance.getOp()); 
            fluent.withValue(instance.getValue()); 
            this.validationEnabled = validationEnabled; 
    }
    public BlkioStatEntryBuilder(BlkioStatEntry instance){
            this(instance,true);
    }
    public BlkioStatEntryBuilder(BlkioStatEntry instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withMajor(instance.getMajor()); 
            this.withMinor(instance.getMinor()); 
            this.withOp(instance.getOp()); 
            this.withValue(instance.getValue()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.docker.api.model.EditableBlkioStatEntry build(){
            EditableBlkioStatEntry buildable = new EditableBlkioStatEntry(fluent.getMajor(),fluent.getMinor(),fluent.getOp(),fluent.getValue());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            BlkioStatEntryBuilder that = (BlkioStatEntryBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
