package io.fabric8.docker.api.model;

import javax.validation.Validation;
import io.fabric8.docker.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class AuthResponseBuilder extends AuthResponseFluentImpl<AuthResponseBuilder> implements VisitableBuilder<AuthResponse,AuthResponseBuilder>{

    AuthResponseFluent<?> fluent;
    Boolean validationEnabled;

    public AuthResponseBuilder(){
            this(true);
    }
    public AuthResponseBuilder(Boolean validationEnabled){
            this(new AuthResponse(), validationEnabled);
    }
    public AuthResponseBuilder(AuthResponseFluent<?> fluent){
            this(fluent, true);
    }
    public AuthResponseBuilder(AuthResponseFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new AuthResponse(), validationEnabled);
    }
    public AuthResponseBuilder(AuthResponseFluent<?> fluent,AuthResponse instance){
            this(fluent, instance, true);
    }
    public AuthResponseBuilder(AuthResponseFluent<?> fluent,AuthResponse instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withStatus(instance.getStatus()); 
            this.validationEnabled = validationEnabled; 
    }
    public AuthResponseBuilder(AuthResponse instance){
            this(instance,true);
    }
    public AuthResponseBuilder(AuthResponse instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withStatus(instance.getStatus()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.docker.api.model.EditableAuthResponse build(){
            EditableAuthResponse buildable = new EditableAuthResponse(fluent.getStatus());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            AuthResponseBuilder that = (AuthResponseBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
