package io.fabric8.docker.api.model;

import javax.validation.Validation;
import io.fabric8.docker.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class AuthConfigBuilder extends AuthConfigFluentImpl<AuthConfigBuilder> implements VisitableBuilder<AuthConfig,AuthConfigBuilder>{

    AuthConfigFluent<?> fluent;
    Boolean validationEnabled;

    public AuthConfigBuilder(){
            this(true);
    }
    public AuthConfigBuilder(Boolean validationEnabled){
            this(new AuthConfig(), validationEnabled);
    }
    public AuthConfigBuilder(AuthConfigFluent<?> fluent){
            this(fluent, true);
    }
    public AuthConfigBuilder(AuthConfigFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new AuthConfig(), validationEnabled);
    }
    public AuthConfigBuilder(AuthConfigFluent<?> fluent,AuthConfig instance){
            this(fluent, instance, true);
    }
    public AuthConfigBuilder(AuthConfigFluent<?> fluent,AuthConfig instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAuth(instance.getAuth()); 
            fluent.withEmail(instance.getEmail()); 
            fluent.withPassword(instance.getPassword()); 
            fluent.withServeraddress(instance.getServeraddress()); 
            fluent.withUsername(instance.getUsername()); 
            this.validationEnabled = validationEnabled; 
    }
    public AuthConfigBuilder(AuthConfig instance){
            this(instance,true);
    }
    public AuthConfigBuilder(AuthConfig instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAuth(instance.getAuth()); 
            this.withEmail(instance.getEmail()); 
            this.withPassword(instance.getPassword()); 
            this.withServeraddress(instance.getServeraddress()); 
            this.withUsername(instance.getUsername()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.docker.api.model.EditableAuthConfig build(){
            EditableAuthConfig buildable = new EditableAuthConfig(fluent.getAuth(),fluent.getEmail(),fluent.getPassword(),fluent.getServeraddress(),fluent.getUsername());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            AuthConfigBuilder that = (AuthConfigBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
