package io.fabric8.docker.api.model;

import javax.validation.Validation;
import io.fabric8.docker.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class AddressBuilder extends AddressFluentImpl<AddressBuilder> implements VisitableBuilder<Address,AddressBuilder>{

    AddressFluent<?> fluent;
    Boolean validationEnabled;

    public AddressBuilder(){
            this(true);
    }
    public AddressBuilder(Boolean validationEnabled){
            this(new Address(), validationEnabled);
    }
    public AddressBuilder(AddressFluent<?> fluent){
            this(fluent, true);
    }
    public AddressBuilder(AddressFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Address(), validationEnabled);
    }
    public AddressBuilder(AddressFluent<?> fluent,Address instance){
            this(fluent, instance, true);
    }
    public AddressBuilder(AddressFluent<?> fluent,Address instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAddr(instance.getAddr()); 
            fluent.withPrefixLen(instance.getPrefixLen()); 
            this.validationEnabled = validationEnabled; 
    }
    public AddressBuilder(Address instance){
            this(instance,true);
    }
    public AddressBuilder(Address instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAddr(instance.getAddr()); 
            this.withPrefixLen(instance.getPrefixLen()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.docker.api.model.EditableAddress build(){
            EditableAddress buildable = new EditableAddress(fluent.getAddr(),fluent.getPrefixLen());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            AddressBuilder that = (AddressBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
