package io.fabric8.docker.api.builder;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.ArrayList;
import java.util.List;
import java.lang.String;
import java.lang.reflect.Method;
import java.lang.Boolean;

public class BaseFluent<F extends Fluent<F>> implements Fluent<F>,Visitable<F>{

    private static final String VISIT = "visit";
    public final List<Visitable> _visitables = new ArrayList<Visitable>();


    public static <T>ArrayList<T> build(List<? extends Builder<? extends T>> list){
            ArrayList<T> result = new ArrayList<T>();
            for (Builder<? extends T> builder : list) {
    result.add(builder.build());
}
            return result;
    }

    public static <T>List<T> build(Set<? extends Builder<? extends T>> list){
            List<T> result = new ArrayList<T>();
            for (Builder<? extends T> builder : list) {
    result.add(builder.build());
}
            return result;
    }

    public static <T>ArrayList<T> aggregate(List<? extends T>... lists){
            ArrayList<T> result = new ArrayList<T>();
            for (List<? extends T> list : lists) {
    result.addAll(list);
}
            return result;
    }

    public static <T>LinkedHashSet<T> aggregate(Set... sets){
            LinkedHashSet<T> result = new LinkedHashSet<T>();
            for (Set<? extends T> set : sets) {
    result.addAll(set);
}
            return result;
    }

    private static <V,F>Boolean canVisit(V visitor,F fluent){
            if (visitor instanceof TypedVisitor) {
    if (!((TypedVisitor) visitor).getType().isAssignableFrom(fluent.getClass())) {
        return false;
    }
}
            if (visitor instanceof PathAwareTypedVisitor) {
    PathAwareTypedVisitor pathAwareTypedVisitor = (PathAwareTypedVisitor) visitor;
    Class parentType = pathAwareTypedVisitor.getParentType();
    Class actaulParentType = pathAwareTypedVisitor.getActualParentType();
    if (!parentType.isAssignableFrom(actaulParentType)) {
        return false;
    }
}
            return hasCompatibleVisitMethod(visitor, fluent);
    }

    private static <V,F>Boolean hasCompatibleVisitMethod(V visitor,F fluent){
            for (Method method : visitor.getClass().getDeclaredMethods()) {
    if (!method.getName().equals(VISIT) || method.getParameterTypes().length != 1) {
        continue;
    }
    Class visitorType = method.getParameterTypes()[0];
    if (visitorType.isAssignableFrom(fluent.getClass())) {
        return true;
    } else {
        return false;
    }
}
            return false;
    }

    public F accept(io.fabric8.docker.api.builder.Visitor visitor){
            if (visitor instanceof PathAwareTypedVisitor) {
    return acceptPathAware((PathAwareTypedVisitor) visitor);
} else {
    return acceptInternal(visitor);
}
    }

    private F acceptInternal(io.fabric8.docker.api.builder.Visitor visitor){
            for (Visitable visitable : _visitables) {
    visitable.accept(visitor);
}
            if (canVisit(visitor, this)) {
    visitor.visit(this);
}
            return (F) this;
    }

    private F acceptPathAware(PathAwareTypedVisitor pathAwareTypedVisitor){
            return acceptInternal(pathAwareTypedVisitor.next(this));
    }




}
