/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.EditableEndpointResource;
import io.fabric8.docker.api.model.EndpointResource;
import io.fabric8.docker.api.model.EndpointResourceFluent;
import io.fabric8.docker.api.model.EndpointResourceFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class EndpointResourceBuilder
extends EndpointResourceFluentImpl<EndpointResourceBuilder>
implements VisitableBuilder<EndpointResource, EndpointResourceBuilder> {
    EndpointResourceFluent<?> fluent;

    public EndpointResourceBuilder() {
        this(new EndpointResource());
    }

    public EndpointResourceBuilder(EndpointResourceFluent<?> fluent) {
        this(fluent, new EndpointResource());
    }

    public EndpointResourceBuilder(EndpointResourceFluent<?> fluent, EndpointResource instance) {
        this.fluent = fluent;
        fluent.withEndpointID(instance.getEndpointID());
        fluent.withIPv4Address(instance.getIPv4Address());
        fluent.withIPv6Address(instance.getIPv6Address());
        fluent.withMacAddress(instance.getMacAddress());
    }

    public EndpointResourceBuilder(EndpointResource instance) {
        this.fluent = this;
        this.withEndpointID(instance.getEndpointID());
        this.withIPv4Address(instance.getIPv4Address());
        this.withIPv6Address(instance.getIPv6Address());
        this.withMacAddress(instance.getMacAddress());
    }

    @Override
    public EditableEndpointResource build() {
        EditableEndpointResource buildable = new EditableEndpointResource(this.fluent.getEndpointID(), this.fluent.getIPv4Address(), this.fluent.getIPv6Address(), this.fluent.getMacAddress());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EndpointResourceBuilder that = (EndpointResourceBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

