/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.ContainerChange;
import io.fabric8.docker.api.model.ContainerChangeFluent;
import io.fabric8.docker.api.model.ContainerChangeFluentImpl;
import io.fabric8.docker.api.model.EditableContainerChange;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ContainerChangeBuilder
extends ContainerChangeFluentImpl<ContainerChangeBuilder>
implements VisitableBuilder<ContainerChange, ContainerChangeBuilder> {
    ContainerChangeFluent<?> fluent;

    public ContainerChangeBuilder() {
        this(new ContainerChange());
    }

    public ContainerChangeBuilder(ContainerChangeFluent<?> fluent) {
        this(fluent, new ContainerChange());
    }

    public ContainerChangeBuilder(ContainerChangeFluent<?> fluent, ContainerChange instance) {
        this.fluent = fluent;
        fluent.withKind(instance.getKind());
        fluent.withPath(instance.getPath());
    }

    public ContainerChangeBuilder(ContainerChange instance) {
        this.fluent = this;
        this.withKind(instance.getKind());
        this.withPath(instance.getPath());
    }

    @Override
    public EditableContainerChange build() {
        EditableContainerChange buildable = new EditableContainerChange(this.fluent.getKind(), this.fluent.getPath());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContainerChangeBuilder that = (ContainerChangeBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

