/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.BlkioStats;
import io.fabric8.docker.api.model.BlkioStatsFluent;
import io.fabric8.docker.api.model.BlkioStatsFluentImpl;
import io.fabric8.docker.api.model.EditableBlkioStats;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class BlkioStatsBuilder
extends BlkioStatsFluentImpl<BlkioStatsBuilder>
implements VisitableBuilder<BlkioStats, BlkioStatsBuilder> {
    BlkioStatsFluent<?> fluent;

    public BlkioStatsBuilder() {
        this(new BlkioStats());
    }

    public BlkioStatsBuilder(BlkioStatsFluent<?> fluent) {
        this(fluent, new BlkioStats());
    }

    public BlkioStatsBuilder(BlkioStatsFluent<?> fluent, BlkioStats instance) {
        this.fluent = fluent;
        fluent.withIoMergedRecursive(instance.getIoMergedRecursive());
        fluent.withIoQueueRecursive(instance.getIoQueueRecursive());
        fluent.withIoServiceBytesRecursive(instance.getIoServiceBytesRecursive());
        fluent.withIoServiceTimeRecursive(instance.getIoServiceTimeRecursive());
        fluent.withIoServicedRecursive(instance.getIoServicedRecursive());
        fluent.withIoTimeRecursive(instance.getIoTimeRecursive());
        fluent.withIoWaitTimeRecursive(instance.getIoWaitTimeRecursive());
        fluent.withSectorsRecursive(instance.getSectorsRecursive());
    }

    public BlkioStatsBuilder(BlkioStats instance) {
        this.fluent = this;
        this.withIoMergedRecursive(instance.getIoMergedRecursive());
        this.withIoQueueRecursive(instance.getIoQueueRecursive());
        this.withIoServiceBytesRecursive(instance.getIoServiceBytesRecursive());
        this.withIoServiceTimeRecursive(instance.getIoServiceTimeRecursive());
        this.withIoServicedRecursive(instance.getIoServicedRecursive());
        this.withIoTimeRecursive(instance.getIoTimeRecursive());
        this.withIoWaitTimeRecursive(instance.getIoWaitTimeRecursive());
        this.withSectorsRecursive(instance.getSectorsRecursive());
    }

    @Override
    public EditableBlkioStats build() {
        EditableBlkioStats buildable = new EditableBlkioStats(this.fluent.getIoMergedRecursive(), this.fluent.getIoQueueRecursive(), this.fluent.getIoServiceBytesRecursive(), this.fluent.getIoServiceTimeRecursive(), this.fluent.getIoServicedRecursive(), this.fluent.getIoTimeRecursive(), this.fluent.getIoWaitTimeRecursive(), this.fluent.getSectorsRecursive());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BlkioStatsBuilder that = (BlkioStatsBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

