
package io.fabric8.docker.api.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.docker.api.model.Doneable;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "blkio_stats",
    "cpu_stats",
    "memory_stats",
    "precpu_stats",
    "read"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = true, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.docker.api.builder", inline = @Inline(type = Doneable.class, prefix = "Doneable", value = "done"))
public class Stats implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("blkio_stats")
    @Valid
    private BlkioStats blkioStats;
    /**
     * 
     * 
     */
    @JsonProperty("cpu_stats")
    @Valid
    private CPUStats cpuStats;
    /**
     * 
     * 
     */
    @JsonProperty("memory_stats")
    @Valid
    private MemoryStats memoryStats;
    /**
     * 
     * 
     */
    @JsonProperty("precpu_stats")
    @Valid
    private CPUStats precpuStats;
    /**
     * 
     * 
     */
    @JsonProperty("read")
    private String read;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public Stats() {
    }

    /**
     * 
     * @param blkioStats
     * @param read
     * @param precpuStats
     * @param memoryStats
     * @param cpuStats
     */
    public Stats(BlkioStats blkioStats, CPUStats cpuStats, MemoryStats memoryStats, CPUStats precpuStats, String read) {
        this.blkioStats = blkioStats;
        this.cpuStats = cpuStats;
        this.memoryStats = memoryStats;
        this.precpuStats = precpuStats;
        this.read = read;
    }

    /**
     * 
     * 
     * @return
     *     The blkioStats
     */
    @JsonProperty("blkio_stats")
    public BlkioStats getBlkioStats() {
        return blkioStats;
    }

    /**
     * 
     * 
     * @param blkioStats
     *     The blkio_stats
     */
    @JsonProperty("blkio_stats")
    public void setBlkioStats(BlkioStats blkioStats) {
        this.blkioStats = blkioStats;
    }

    /**
     * 
     * 
     * @return
     *     The cpuStats
     */
    @JsonProperty("cpu_stats")
    public CPUStats getCpuStats() {
        return cpuStats;
    }

    /**
     * 
     * 
     * @param cpuStats
     *     The cpu_stats
     */
    @JsonProperty("cpu_stats")
    public void setCpuStats(CPUStats cpuStats) {
        this.cpuStats = cpuStats;
    }

    /**
     * 
     * 
     * @return
     *     The memoryStats
     */
    @JsonProperty("memory_stats")
    public MemoryStats getMemoryStats() {
        return memoryStats;
    }

    /**
     * 
     * 
     * @param memoryStats
     *     The memory_stats
     */
    @JsonProperty("memory_stats")
    public void setMemoryStats(MemoryStats memoryStats) {
        this.memoryStats = memoryStats;
    }

    /**
     * 
     * 
     * @return
     *     The precpuStats
     */
    @JsonProperty("precpu_stats")
    public CPUStats getPrecpuStats() {
        return precpuStats;
    }

    /**
     * 
     * 
     * @param precpuStats
     *     The precpu_stats
     */
    @JsonProperty("precpu_stats")
    public void setPrecpuStats(CPUStats precpuStats) {
        this.precpuStats = precpuStats;
    }

    /**
     * 
     * 
     * @return
     *     The read
     */
    @JsonProperty("read")
    public String getRead() {
        return read;
    }

    /**
     * 
     * 
     * @param read
     *     The read
     */
    @JsonProperty("read")
    public void setRead(String read) {
        this.read = read;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
