package io.fabric8.docker.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.Builder;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.builder.Fluent;

public class LogConfigBuilder extends LogConfigFluentImpl<LogConfigBuilder> implements VisitableBuilder<LogConfig,LogConfigBuilder>{

     LogConfigFluent<?> fluent;
public LogConfigBuilder(){
    this(new LogConfig());
}
public LogConfigBuilder( LogConfigFluent<?> fluent ){
    this(fluent, new LogConfig());
}
public LogConfigBuilder( LogConfigFluent<?> fluent , LogConfig instance ){
    this.fluent = fluent; fluent.withConfig(instance.getConfig()); fluent.withType(instance.getType()); 
}
public LogConfigBuilder( LogConfig instance ){
    this.fluent = this; this.withConfig(instance.getConfig()); this.withType(instance.getType()); 
}

public EditableLogConfig build(){
    EditableLogConfig buildable = new EditableLogConfig(fluent.getConfig(),fluent.getType());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
LogConfigBuilder that = (LogConfigBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
