/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.EditableNetworkSettings;
import io.fabric8.docker.api.model.NetworkSettings;
import io.fabric8.docker.api.model.NetworkSettingsFluent;
import io.fabric8.docker.api.model.NetworkSettingsFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class NetworkSettingsBuilder
extends NetworkSettingsFluentImpl<NetworkSettingsBuilder>
implements VisitableBuilder<NetworkSettings, NetworkSettingsBuilder> {
    NetworkSettingsFluent<?> fluent;

    public NetworkSettingsBuilder() {
        this(new NetworkSettings());
    }

    public NetworkSettingsBuilder(NetworkSettingsFluent<?> fluent) {
        this(fluent, new NetworkSettings());
    }

    public NetworkSettingsBuilder(NetworkSettingsFluent<?> fluent, NetworkSettings instance) {
        this.fluent = fluent;
        fluent.withDefaultNetworkSettings(instance.getDefaultNetworkSettings());
        fluent.withNetworkSettingsBase(instance.getNetworkSettingsBase());
        fluent.withNetworks(instance.getNetworks());
    }

    public NetworkSettingsBuilder(NetworkSettings instance) {
        this.fluent = this;
        this.withDefaultNetworkSettings(instance.getDefaultNetworkSettings());
        this.withNetworkSettingsBase(instance.getNetworkSettingsBase());
        this.withNetworks(instance.getNetworks());
    }

    @Override
    public EditableNetworkSettings build() {
        EditableNetworkSettings buildable = new EditableNetworkSettings(this.fluent.getDefaultNetworkSettings(), this.fluent.getNetworkSettingsBase(), this.fluent.getNetworks());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NetworkSettingsBuilder that = (NetworkSettingsBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

