/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.AuthResponse;
import io.fabric8.docker.api.model.AuthResponseFluent;
import io.fabric8.docker.api.model.AuthResponseFluentImpl;
import io.fabric8.docker.api.model.EditableAuthResponse;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class AuthResponseBuilder
extends AuthResponseFluentImpl<AuthResponseBuilder>
implements VisitableBuilder<AuthResponse, AuthResponseBuilder> {
    AuthResponseFluent<?> fluent;

    public AuthResponseBuilder() {
        this(new AuthResponse());
    }

    public AuthResponseBuilder(AuthResponseFluent<?> fluent) {
        this(fluent, new AuthResponse());
    }

    public AuthResponseBuilder(AuthResponseFluent<?> fluent, AuthResponse instance) {
        this.fluent = fluent;
        fluent.withStatus(instance.getStatus());
    }

    public AuthResponseBuilder(AuthResponse instance) {
        this.fluent = this;
        this.withStatus(instance.getStatus());
    }

    @Override
    public EditableAuthResponse build() {
        EditableAuthResponse buildable = new EditableAuthResponse(this.fluent.getStatus());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AuthResponseBuilder that = (AuthResponseBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

