
package io.fabric8.docker.api.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.docker.api.model.Doneable;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "cpu_usage",
    "system_cpu_usage",
    "throttling_data"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = true, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.docker.api.builder", inline = @Inline(type = Doneable.class, prefix = "Doneable", value = "done"))
public class CPUStats implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("cpu_usage")
    @Valid
    private CPUUsage cpuUsage;
    /**
     * 
     * 
     */
    @JsonProperty("system_cpu_usage")
    private Long systemCpuUsage;
    /**
     * 
     * 
     */
    @JsonProperty("throttling_data")
    @Valid
    private ThrottlingData throttlingData;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public CPUStats() {
    }

    /**
     * 
     * @param cpuUsage
     * @param systemCpuUsage
     * @param throttlingData
     */
    public CPUStats(CPUUsage cpuUsage, Long systemCpuUsage, ThrottlingData throttlingData) {
        this.cpuUsage = cpuUsage;
        this.systemCpuUsage = systemCpuUsage;
        this.throttlingData = throttlingData;
    }

    /**
     * 
     * 
     * @return
     *     The cpuUsage
     */
    @JsonProperty("cpu_usage")
    public CPUUsage getCpuUsage() {
        return cpuUsage;
    }

    /**
     * 
     * 
     * @param cpuUsage
     *     The cpu_usage
     */
    @JsonProperty("cpu_usage")
    public void setCpuUsage(CPUUsage cpuUsage) {
        this.cpuUsage = cpuUsage;
    }

    /**
     * 
     * 
     * @return
     *     The systemCpuUsage
     */
    @JsonProperty("system_cpu_usage")
    public Long getSystemCpuUsage() {
        return systemCpuUsage;
    }

    /**
     * 
     * 
     * @param systemCpuUsage
     *     The system_cpu_usage
     */
    @JsonProperty("system_cpu_usage")
    public void setSystemCpuUsage(Long systemCpuUsage) {
        this.systemCpuUsage = systemCpuUsage;
    }

    /**
     * 
     * 
     * @return
     *     The throttlingData
     */
    @JsonProperty("throttling_data")
    public ThrottlingData getThrottlingData() {
        return throttlingData;
    }

    /**
     * 
     * 
     * @param throttlingData
     *     The throttling_data
     */
    @JsonProperty("throttling_data")
    public void setThrottlingData(ThrottlingData throttlingData) {
        this.throttlingData = throttlingData;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
