package io.fabric8.docker.api.model;

import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.Builder;
import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.builder.Nested;
import io.fabric8.docker.api.builder.Fluent;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.builder.VisitableBuilder;

public class StatsFluentImpl<T extends StatsFluent<T>> extends BaseFluent<T> implements StatsFluent<T>{

     VisitableBuilder<BlkioStats, ?> blkioStats;     VisitableBuilder<CPUStats, ?> cpuStats;     VisitableBuilder<MemoryStats, ?> memoryStats;     VisitableBuilder<CPUStats, ?> precpuStats;     String read;     Map<String, Object> additionalProperties = new HashMap();
public StatsFluentImpl(){
    
}
public StatsFluentImpl( Stats instance ){
    this.withBlkioStats(instance.getBlkioStats()); this.withCpuStats(instance.getCpuStats()); this.withMemoryStats(instance.getMemoryStats()); this.withPrecpuStats(instance.getPrecpuStats()); this.withRead(instance.getRead()); 
}

    public BlkioStats getBlkioStats(){
    return this.blkioStats!=null?this.blkioStats.build():null;
    }
    public T withBlkioStats( BlkioStats blkioStats){
    if (blkioStats!=null){ this.blkioStats= new BlkioStatsBuilder(blkioStats); _visitables.add(this.blkioStats);} return (T) this;
    }
    public BlkioStatsNested<T> withNewBlkioStats(){
    return new BlkioStatsNestedImpl<T>();
    }
    public BlkioStatsNested<T> withNewBlkioStatsLike( BlkioStats item){
    return new BlkioStatsNestedImpl<T>(item);
    }
    public BlkioStatsNested<T> editBlkioStats(){
    return withNewBlkioStatsLike(getBlkioStats());
    }
    public CPUStats getCpuStats(){
    return this.cpuStats!=null?this.cpuStats.build():null;
    }
    public T withCpuStats( CPUStats cpuStats){
    if (cpuStats!=null){ this.cpuStats= new CPUStatsBuilder(cpuStats); _visitables.add(this.cpuStats);} return (T) this;
    }
    public CpuStatsNested<T> withNewCpuStats(){
    return new CpuStatsNestedImpl<T>();
    }
    public CpuStatsNested<T> withNewCpuStatsLike( CPUStats item){
    return new CpuStatsNestedImpl<T>(item);
    }
    public CpuStatsNested<T> editCpuStats(){
    return withNewCpuStatsLike(getCpuStats());
    }
    public MemoryStats getMemoryStats(){
    return this.memoryStats!=null?this.memoryStats.build():null;
    }
    public T withMemoryStats( MemoryStats memoryStats){
    if (memoryStats!=null){ this.memoryStats= new MemoryStatsBuilder(memoryStats); _visitables.add(this.memoryStats);} return (T) this;
    }
    public MemoryStatsNested<T> withNewMemoryStats(){
    return new MemoryStatsNestedImpl<T>();
    }
    public MemoryStatsNested<T> withNewMemoryStatsLike( MemoryStats item){
    return new MemoryStatsNestedImpl<T>(item);
    }
    public MemoryStatsNested<T> editMemoryStats(){
    return withNewMemoryStatsLike(getMemoryStats());
    }
    public CPUStats getPrecpuStats(){
    return this.precpuStats!=null?this.precpuStats.build():null;
    }
    public T withPrecpuStats( CPUStats precpuStats){
    if (precpuStats!=null){ this.precpuStats= new CPUStatsBuilder(precpuStats); _visitables.add(this.precpuStats);} return (T) this;
    }
    public PrecpuStatsNested<T> withNewPrecpuStats(){
    return new PrecpuStatsNestedImpl<T>();
    }
    public PrecpuStatsNested<T> withNewPrecpuStatsLike( CPUStats item){
    return new PrecpuStatsNestedImpl<T>(item);
    }
    public PrecpuStatsNested<T> editPrecpuStats(){
    return withNewPrecpuStatsLike(getPrecpuStats());
    }
    public String getRead(){
    return this.read;
    }
    public T withRead( String read){
    this.read=read; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
StatsFluentImpl that = (StatsFluentImpl) o;
if (blkioStats != null ? !blkioStats.equals(that.blkioStats) :that.blkioStats != null) return false;
if (cpuStats != null ? !cpuStats.equals(that.cpuStats) :that.cpuStats != null) return false;
if (memoryStats != null ? !memoryStats.equals(that.memoryStats) :that.memoryStats != null) return false;
if (precpuStats != null ? !precpuStats.equals(that.precpuStats) :that.precpuStats != null) return false;
if (read != null ? !read.equals(that.read) :that.read != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class BlkioStatsNestedImpl<N> extends BlkioStatsFluentImpl<BlkioStatsNested<N>> implements BlkioStatsNested<N>{

        private final BlkioStatsBuilder builder;
    
             BlkioStatsNestedImpl (){
        this.builder = new BlkioStatsBuilder(this);
        }
             BlkioStatsNestedImpl ( BlkioStats item){
        this.builder = new BlkioStatsBuilder(this, item);
        }
    
            public N endBlkioStats(){
            return and();
        }
            public N and(){
            return (N) StatsFluentImpl.this.withBlkioStats(builder.build());
        }
    
}
    public class CpuStatsNestedImpl<N> extends CPUStatsFluentImpl<CpuStatsNested<N>> implements CpuStatsNested<N>{

        private final CPUStatsBuilder builder;
    
             CpuStatsNestedImpl (){
        this.builder = new CPUStatsBuilder(this);
        }
             CpuStatsNestedImpl ( CPUStats item){
        this.builder = new CPUStatsBuilder(this, item);
        }
    
            public N and(){
            return (N) StatsFluentImpl.this.withCpuStats(builder.build());
        }
            public N endCpuStats(){
            return and();
        }
    
}
    public class MemoryStatsNestedImpl<N> extends MemoryStatsFluentImpl<MemoryStatsNested<N>> implements MemoryStatsNested<N>{

        private final MemoryStatsBuilder builder;
    
             MemoryStatsNestedImpl (){
        this.builder = new MemoryStatsBuilder(this);
        }
             MemoryStatsNestedImpl ( MemoryStats item){
        this.builder = new MemoryStatsBuilder(this, item);
        }
    
            public N and(){
            return (N) StatsFluentImpl.this.withMemoryStats(builder.build());
        }
            public N endMemoryStats(){
            return and();
        }
    
}
    public class PrecpuStatsNestedImpl<N> extends CPUStatsFluentImpl<PrecpuStatsNested<N>> implements PrecpuStatsNested<N>{

        private final CPUStatsBuilder builder;
    
             PrecpuStatsNestedImpl (){
        this.builder = new CPUStatsBuilder(this);
        }
             PrecpuStatsNestedImpl ( CPUStats item){
        this.builder = new CPUStatsBuilder(this, item);
        }
    
            public N endPrecpuStats(){
            return and();
        }
            public N and(){
            return (N) StatsFluentImpl.this.withPrecpuStats(builder.build());
        }
    
}


}
