package io.fabric8.docker.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.Builder;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.Fluent;

public class NetworkSettingsBuilder extends NetworkSettingsFluentImpl<NetworkSettingsBuilder> implements VisitableBuilder<NetworkSettings,NetworkSettingsBuilder>{

     NetworkSettingsFluent<?> fluent;
public NetworkSettingsBuilder(){
    this(new NetworkSettings());
}
public NetworkSettingsBuilder( NetworkSettingsFluent<?> fluent ){
    this(fluent, new NetworkSettings());
}
public NetworkSettingsBuilder( NetworkSettingsFluent<?> fluent , NetworkSettings instance ){
    this.fluent = fluent; fluent.withDefaultNetworkSettings(instance.getDefaultNetworkSettings()); fluent.withNetworkSettingsBase(instance.getNetworkSettingsBase()); fluent.withNetworks(instance.getNetworks()); 
}
public NetworkSettingsBuilder( NetworkSettings instance ){
    this.fluent = this; this.withDefaultNetworkSettings(instance.getDefaultNetworkSettings()); this.withNetworkSettingsBase(instance.getNetworkSettingsBase()); this.withNetworks(instance.getNetworks()); 
}

public EditableNetworkSettings build(){
    EditableNetworkSettings buildable = new EditableNetworkSettings(fluent.getDefaultNetworkSettings(),fluent.getNetworkSettingsBase(),fluent.getNetworks());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
NetworkSettingsBuilder that = (NetworkSettingsBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
