package io.fabric8.docker.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.ArrayList;
import java.util.AbstractCollection;
import java.util.List;
import java.util.Map;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.Builder;
import io.fabric8.docker.api.builder.Nested;
import io.fabric8.docker.api.builder.Fluent;
import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.BaseFluent;
import java.util.List;

public class NetworkSettingsBaseFluentImpl<T extends NetworkSettingsBaseFluent<T>> extends BaseFluent<T> implements NetworkSettingsBaseFluent<T>{

     String Bridge;     Boolean HairpinMode;     String LinkLocalIPv6Address;     Integer LinkLocalIPv6PrefixLen;     Map<String, ArrayList<PortBinding>> Ports = new HashMap();     String SandboxID;     String SandboxKey;     List<VisitableBuilder<Address, ?>> SecondaryIPAddresses = new ArrayList();     List<VisitableBuilder<Address, ?>> SecondaryIPv6Addresses = new ArrayList();     Map<String, Object> additionalProperties = new HashMap();
public NetworkSettingsBaseFluentImpl(){
    
}
public NetworkSettingsBaseFluentImpl( NetworkSettingsBase instance ){
    this.withBridge(instance.getBridge()); this.withHairpinMode(instance.getHairpinMode()); this.withLinkLocalIPv6Address(instance.getLinkLocalIPv6Address()); this.withLinkLocalIPv6PrefixLen(instance.getLinkLocalIPv6PrefixLen()); this.withPorts(instance.getPorts()); this.withSandboxID(instance.getSandboxID()); this.withSandboxKey(instance.getSandboxKey()); this.withSecondaryIPAddresses(instance.getSecondaryIPAddresses()); this.withSecondaryIPv6Addresses(instance.getSecondaryIPv6Addresses()); 
}

    public String getBridge(){
    return this.Bridge;
    }
    public T withBridge( String Bridge){
    this.Bridge=Bridge; return (T) this;
    }
    public Boolean isHairpinMode(){
    return this.HairpinMode;
    }
    public T withHairpinMode( Boolean HairpinMode){
    this.HairpinMode=HairpinMode; return (T) this;
    }
    public String getLinkLocalIPv6Address(){
    return this.LinkLocalIPv6Address;
    }
    public T withLinkLocalIPv6Address( String LinkLocalIPv6Address){
    this.LinkLocalIPv6Address=LinkLocalIPv6Address; return (T) this;
    }
    public Integer getLinkLocalIPv6PrefixLen(){
    return this.LinkLocalIPv6PrefixLen;
    }
    public T withLinkLocalIPv6PrefixLen( Integer LinkLocalIPv6PrefixLen){
    this.LinkLocalIPv6PrefixLen=LinkLocalIPv6PrefixLen; return (T) this;
    }
    public T addToPorts( String key,  ArrayList<PortBinding> value){
    if(key != null && value != null) {this.Ports.put(key, value);} return (T)this;
    }
    public T addToPorts( Map<String, ArrayList<PortBinding>> map){
    if(map != null) { this.Ports.putAll(map);} return (T)this;
    }
    public T removeFromPorts( String key){
    if(key != null) {this.Ports.remove(key);} return (T)this;
    }
    public T removeFromPorts( Map<String, ArrayList<PortBinding>> map){
    if(map != null) { for(Object key : map.keySet()) {this.Ports.remove(key);}} return (T)this;
    }
    public Map<String, ArrayList<PortBinding>> getPorts(){
    return this.Ports;
    }
    public T withPorts( Map<String, ArrayList<PortBinding>> Ports){
    this.Ports.clear();if (Ports != null) {this.Ports.putAll(Ports);} return (T) this;
    }
    public String getSandboxID(){
    return this.SandboxID;
    }
    public T withSandboxID( String SandboxID){
    this.SandboxID=SandboxID; return (T) this;
    }
    public String getSandboxKey(){
    return this.SandboxKey;
    }
    public T withSandboxKey( String SandboxKey){
    this.SandboxKey=SandboxKey; return (T) this;
    }
    public T addToSecondaryIPAddresses( Address ...items){
    for (Address item : items) {AddressBuilder builder = new AddressBuilder(item);_visitables.add(builder);this.SecondaryIPAddresses.add(builder);} return (T)this;
    }
    public T removeFromSecondaryIPAddresses( Address ...items){
    for (Address item : items) {AddressBuilder builder = new AddressBuilder(item);_visitables.remove(builder);this.SecondaryIPAddresses.remove(builder);} return (T)this;
    }
    public List<Address> getSecondaryIPAddresses(){
    return build(SecondaryIPAddresses);
    }
    public T withSecondaryIPAddresses( List<Address> SecondaryIPAddresses){
    this.SecondaryIPAddresses.clear();if (SecondaryIPAddresses != null) {for (Address item : SecondaryIPAddresses){this.addToSecondaryIPAddresses(item);}} return (T) this;
    }
    public T withSecondaryIPAddresses( Address ...SecondaryIPAddresses){
    this.SecondaryIPAddresses.clear(); if (SecondaryIPAddresses != null) {for (Address item :SecondaryIPAddresses){ this.addToSecondaryIPAddresses(item);}} return (T) this;
    }
    public SecondaryIPAddressesNested<T> addNewSecondaryIPAddresse(){
    return new SecondaryIPAddressesNestedImpl<T>();
    }
    public SecondaryIPAddressesNested<T> addNewSecondaryIPAddresseLike( Address item){
    return new SecondaryIPAddressesNestedImpl<T>(item);
    }
    public T addNewSecondaryIPAddresse( String Addr,  Integer PrefixLen){
    return addToSecondaryIPAddresses(new Address(Addr, PrefixLen));
    }
    public T addToSecondaryIPv6Addresses( Address ...items){
    for (Address item : items) {AddressBuilder builder = new AddressBuilder(item);_visitables.add(builder);this.SecondaryIPv6Addresses.add(builder);} return (T)this;
    }
    public T removeFromSecondaryIPv6Addresses( Address ...items){
    for (Address item : items) {AddressBuilder builder = new AddressBuilder(item);_visitables.remove(builder);this.SecondaryIPv6Addresses.remove(builder);} return (T)this;
    }
    public List<Address> getSecondaryIPv6Addresses(){
    return build(SecondaryIPv6Addresses);
    }
    public T withSecondaryIPv6Addresses( List<Address> SecondaryIPv6Addresses){
    this.SecondaryIPv6Addresses.clear();if (SecondaryIPv6Addresses != null) {for (Address item : SecondaryIPv6Addresses){this.addToSecondaryIPv6Addresses(item);}} return (T) this;
    }
    public T withSecondaryIPv6Addresses( Address ...SecondaryIPv6Addresses){
    this.SecondaryIPv6Addresses.clear(); if (SecondaryIPv6Addresses != null) {for (Address item :SecondaryIPv6Addresses){ this.addToSecondaryIPv6Addresses(item);}} return (T) this;
    }
    public SecondaryIPv6AddressesNested<T> addNewSecondaryIPv6Addresse(){
    return new SecondaryIPv6AddressesNestedImpl<T>();
    }
    public SecondaryIPv6AddressesNested<T> addNewSecondaryIPv6AddresseLike( Address item){
    return new SecondaryIPv6AddressesNestedImpl<T>(item);
    }
    public T addNewSecondaryIPv6Addresse( String Addr,  Integer PrefixLen){
    return addToSecondaryIPv6Addresses(new Address(Addr, PrefixLen));
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
NetworkSettingsBaseFluentImpl that = (NetworkSettingsBaseFluentImpl) o;
if (Bridge != null ? !Bridge.equals(that.Bridge) :that.Bridge != null) return false;
if (HairpinMode != null ? !HairpinMode.equals(that.HairpinMode) :that.HairpinMode != null) return false;
if (LinkLocalIPv6Address != null ? !LinkLocalIPv6Address.equals(that.LinkLocalIPv6Address) :that.LinkLocalIPv6Address != null) return false;
if (LinkLocalIPv6PrefixLen != null ? !LinkLocalIPv6PrefixLen.equals(that.LinkLocalIPv6PrefixLen) :that.LinkLocalIPv6PrefixLen != null) return false;
if (Ports != null ? !Ports.equals(that.Ports) :that.Ports != null) return false;
if (SandboxID != null ? !SandboxID.equals(that.SandboxID) :that.SandboxID != null) return false;
if (SandboxKey != null ? !SandboxKey.equals(that.SandboxKey) :that.SandboxKey != null) return false;
if (SecondaryIPAddresses != null ? !SecondaryIPAddresses.equals(that.SecondaryIPAddresses) :that.SecondaryIPAddresses != null) return false;
if (SecondaryIPv6Addresses != null ? !SecondaryIPv6Addresses.equals(that.SecondaryIPv6Addresses) :that.SecondaryIPv6Addresses != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class SecondaryIPAddressesNestedImpl<N> extends AddressFluentImpl<SecondaryIPAddressesNested<N>> implements SecondaryIPAddressesNested<N>{

        private final AddressBuilder builder;
    
             SecondaryIPAddressesNestedImpl (){
        this.builder = new AddressBuilder(this);
        }
             SecondaryIPAddressesNestedImpl ( Address item){
        this.builder = new AddressBuilder(this, item);
        }
    
            public N endSecondaryIPAddresse(){
            return and();
        }
            public N and(){
            return (N) NetworkSettingsBaseFluentImpl.this.addToSecondaryIPAddresses(builder.build());
        }
    
}
    public class SecondaryIPv6AddressesNestedImpl<N> extends AddressFluentImpl<SecondaryIPv6AddressesNested<N>> implements SecondaryIPv6AddressesNested<N>{

        private final AddressBuilder builder;
    
             SecondaryIPv6AddressesNestedImpl (){
        this.builder = new AddressBuilder(this);
        }
             SecondaryIPv6AddressesNestedImpl ( Address item){
        this.builder = new AddressBuilder(this, item);
        }
    
            public N and(){
            return (N) NetworkSettingsBaseFluentImpl.this.addToSecondaryIPv6Addresses(builder.build());
        }
            public N endSecondaryIPv6Addresse(){
            return and();
        }
    
}


}
