package io.fabric8.docker.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.Fluent;

public class ImageHistoryFluentImpl<T extends ImageHistoryFluent<T>> extends BaseFluent<T> implements ImageHistoryFluent<T>{

     String Comment;     Long Created;     String CreatedBy;     String Id;     Long Size;     List<String> Tags = new ArrayList();     Map<String, Object> additionalProperties = new HashMap();
public ImageHistoryFluentImpl(){
    
}
public ImageHistoryFluentImpl( ImageHistory instance ){
    this.withComment(instance.getComment()); this.withCreated(instance.getCreated()); this.withCreatedBy(instance.getCreatedBy()); this.withId(instance.getId()); this.withSize(instance.getSize()); this.withTags(instance.getTags()); 
}

    public String getComment(){
    return this.Comment;
    }
    public T withComment( String Comment){
    this.Comment=Comment; return (T) this;
    }
    public Long getCreated(){
    return this.Created;
    }
    public T withCreated( Long Created){
    this.Created=Created; return (T) this;
    }
    public String getCreatedBy(){
    return this.CreatedBy;
    }
    public T withCreatedBy( String CreatedBy){
    this.CreatedBy=CreatedBy; return (T) this;
    }
    public String getId(){
    return this.Id;
    }
    public T withId( String Id){
    this.Id=Id; return (T) this;
    }
    public Long getSize(){
    return this.Size;
    }
    public T withSize( Long Size){
    this.Size=Size; return (T) this;
    }
    public T addToTags( String ...items){
    for (String item : items) {this.Tags.add(item);} return (T)this;
    }
    public T removeFromTags( String ...items){
    for (String item : items) {this.Tags.remove(item);} return (T)this;
    }
    public List<String> getTags(){
    return this.Tags;
    }
    public T withTags( List<String> Tags){
    this.Tags.clear();if (Tags != null) {for (String item : Tags){this.addToTags(item);}} return (T) this;
    }
    public T withTags( String ...Tags){
    this.Tags.clear(); if (Tags != null) {for (String item :Tags){ this.addToTags(item);}} return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
ImageHistoryFluentImpl that = (ImageHistoryFluentImpl) o;
if (Comment != null ? !Comment.equals(that.Comment) :that.Comment != null) return false;
if (Created != null ? !Created.equals(that.Created) :that.Created != null) return false;
if (CreatedBy != null ? !CreatedBy.equals(that.CreatedBy) :that.CreatedBy != null) return false;
if (Id != null ? !Id.equals(that.Id) :that.Id != null) return false;
if (Size != null ? !Size.equals(that.Size) :that.Size != null) return false;
if (Tags != null ? !Tags.equals(that.Tags) :that.Tags != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }



}
