package io.fabric8.docker.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.Builder;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.Fluent;
import io.fabric8.docker.api.builder.VisitableBuilder;

public class ImageBuilder extends ImageFluentImpl<ImageBuilder> implements VisitableBuilder<Image,ImageBuilder>{

     ImageFluent<?> fluent;
public ImageBuilder(){
    this(new Image());
}
public ImageBuilder( ImageFluent<?> fluent ){
    this(fluent, new Image());
}
public ImageBuilder( ImageFluent<?> fluent , Image instance ){
    this.fluent = fluent; fluent.withCreated(instance.getCreated()); fluent.withId(instance.getId()); fluent.withLabels(instance.getLabels()); fluent.withParentId(instance.getParentId()); fluent.withRepoDigests(instance.getRepoDigests()); fluent.withRepoTags(instance.getRepoTags()); fluent.withSize(instance.getSize()); fluent.withVirtualSize(instance.getVirtualSize()); 
}
public ImageBuilder( Image instance ){
    this.fluent = this; this.withCreated(instance.getCreated()); this.withId(instance.getId()); this.withLabels(instance.getLabels()); this.withParentId(instance.getParentId()); this.withRepoDigests(instance.getRepoDigests()); this.withRepoTags(instance.getRepoTags()); this.withSize(instance.getSize()); this.withVirtualSize(instance.getVirtualSize()); 
}

public EditableImage build(){
    EditableImage buildable = new EditableImage(fluent.getCreated(),fluent.getId(),fluent.getLabels(),fluent.getParentId(),fluent.getRepoDigests(),fluent.getRepoTags(),fluent.getSize(),fluent.getVirtualSize());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
ImageBuilder that = (ImageBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
