package io.fabric8.docker.api.model;

import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.HashMap;
import io.fabric8.docker.api.builder.Nested;
import io.fabric8.docker.api.builder.Fluent;

public interface DockerSchemaFluent<T extends DockerSchemaFluent<T>> extends Fluent<T>{


    public Address getAddress();    public T withAddress( Address Address);    public AddressNested<T> withNewAddress();    public AddressNested<T> withNewAddressLike( Address item);    public AddressNested<T> editAddress();    public T withNewAddress( String Addr,  Integer PrefixLen);    public AuthConfig getAuthConfig();    public T withAuthConfig( AuthConfig AuthConfig);    public AuthConfigNested<T> withNewAuthConfig();    public AuthConfigNested<T> withNewAuthConfigLike( AuthConfig item);    public AuthConfigNested<T> editAuthConfig();    public T withNewAuthConfig( String auth,  String email,  String password,  String serveraddress,  String username);    public AuthResponse getAuthResponse();    public T withAuthResponse( AuthResponse AuthResponse);    public AuthResponseNested<T> withNewAuthResponse();    public AuthResponseNested<T> withNewAuthResponseLike( AuthResponse item);    public AuthResponseNested<T> editAuthResponse();    public T withNewAuthResponse( String Status);    public ContainerChange getContainerChange();    public T withContainerChange( ContainerChange ContainerChange);    public ContainerChangeNested<T> withNewContainerChange();    public ContainerChangeNested<T> withNewContainerChangeLike( ContainerChange item);    public ContainerChangeNested<T> editContainerChange();    public T withNewContainerChange( Integer Kind,  String Path);    public ContainerCommitResponse getContainerCommitResponse();    public T withContainerCommitResponse( ContainerCommitResponse ContainerCommitResponse);    public ContainerCommitResponseNested<T> withNewContainerCommitResponse();    public ContainerCommitResponseNested<T> withNewContainerCommitResponseLike( ContainerCommitResponse item);    public ContainerCommitResponseNested<T> editContainerCommitResponse();    public T withNewContainerCommitResponse( String Id);    public ContainerCreateResponse getContainerCreateResponse();    public T withContainerCreateResponse( ContainerCreateResponse ContainerCreateResponse);    public ContainerCreateResponseNested<T> withNewContainerCreateResponse();    public ContainerCreateResponseNested<T> withNewContainerCreateResponseLike( ContainerCreateResponse item);    public ContainerCreateResponseNested<T> editContainerCreateResponse();    public ContainerExecCreateResponse getContainerExecCreateResponse();    public T withContainerExecCreateResponse( ContainerExecCreateResponse ContainerExecCreateResponse);    public ContainerExecCreateResponseNested<T> withNewContainerExecCreateResponse();    public ContainerExecCreateResponseNested<T> withNewContainerExecCreateResponseLike( ContainerExecCreateResponse item);    public ContainerExecCreateResponseNested<T> editContainerExecCreateResponse();    public T withNewContainerExecCreateResponse( String Id);    public ContainerJSONBase getContainerJSONBase();    public T withContainerJSONBase( ContainerJSONBase ContainerJSONBase);    public ContainerJSONBaseNested<T> withNewContainerJSONBase();    public ContainerJSONBaseNested<T> withNewContainerJSONBaseLike( ContainerJSONBase item);    public ContainerJSONBaseNested<T> editContainerJSONBase();    public ContainerPathStat getContainerPathStat();    public T withContainerPathStat( ContainerPathStat ContainerPathStat);    public ContainerPathStatNested<T> withNewContainerPathStat();    public ContainerPathStatNested<T> withNewContainerPathStatLike( ContainerPathStat item);    public ContainerPathStatNested<T> editContainerPathStat();    public T withNewContainerPathStat( String linkTarget,  Integer mode,  String mtime,  String name,  Long size);    public ContainerProcessList getContainerProcessList();    public T withContainerProcessList( ContainerProcessList ContainerProcessList);    public ContainerProcessListNested<T> withNewContainerProcessList();    public ContainerProcessListNested<T> withNewContainerProcessListLike( ContainerProcessList item);    public ContainerProcessListNested<T> editContainerProcessList();    public ContainerState getContainerState();    public T withContainerState( ContainerState ContainerState);    public ContainerStateNested<T> withNewContainerState();    public ContainerStateNested<T> withNewContainerStateLike( ContainerState item);    public ContainerStateNested<T> editContainerState();    public ContainerWaitResponse getContainerWaitResponse();    public T withContainerWaitResponse( ContainerWaitResponse ContainerWaitResponse);    public ContainerWaitResponseNested<T> withNewContainerWaitResponse();    public ContainerWaitResponseNested<T> withNewContainerWaitResponseLike( ContainerWaitResponse item);    public ContainerWaitResponseNested<T> editContainerWaitResponse();    public T withNewContainerWaitResponse( Integer StatusCode);    public CopyConfig getCopyConfig();    public T withCopyConfig( CopyConfig CopyConfig);    public CopyConfigNested<T> withNewCopyConfig();    public CopyConfigNested<T> withNewCopyConfigLike( CopyConfig item);    public CopyConfigNested<T> editCopyConfig();    public T withNewCopyConfig( String Resource);    public DefaultNetworkSettings getDefaultNetworkSettings();    public T withDefaultNetworkSettings( DefaultNetworkSettings DefaultNetworkSettings);    public DefaultNetworkSettingsNested<T> withNewDefaultNetworkSettings();    public DefaultNetworkSettingsNested<T> withNewDefaultNetworkSettingsLike( DefaultNetworkSettings item);    public DefaultNetworkSettingsNested<T> editDefaultNetworkSettings();    public EndpointResource getEndpointResource();    public T withEndpointResource( EndpointResource EndpointResource);    public EndpointResourceNested<T> withNewEndpointResource();    public EndpointResourceNested<T> withNewEndpointResourceLike( EndpointResource item);    public EndpointResourceNested<T> editEndpointResource();    public T withNewEndpointResource( String EndpointID,  String IPv4Address,  String IPv6Address,  String MacAddress);    public EndpointSettings getEndpointSettings();    public T withEndpointSettings( EndpointSettings EndpointSettings);    public EndpointSettingsNested<T> withNewEndpointSettings();    public EndpointSettingsNested<T> withNewEndpointSettingsLike( EndpointSettings item);    public EndpointSettingsNested<T> editEndpointSettings();    public ExecConfig getExecConfig();    public T withExecConfig( ExecConfig ExecConfig);    public ExecConfigNested<T> withNewExecConfig();    public ExecConfigNested<T> withNewExecConfigLike( ExecConfig item);    public ExecConfigNested<T> editExecConfig();    public ExecStartCheck getExecStartCheck();    public T withExecStartCheck( ExecStartCheck ExecStartCheck);    public ExecStartCheckNested<T> withNewExecStartCheck();    public ExecStartCheckNested<T> withNewExecStartCheckLike( ExecStartCheck item);    public ExecStartCheckNested<T> editExecStartCheck();    public T withNewExecStartCheck( Boolean Detach,  Boolean Tty);    public GraphDriverData getGraphDriverData();    public T withGraphDriverData( GraphDriverData GraphDriverData);    public GraphDriverDataNested<T> withNewGraphDriverData();    public GraphDriverDataNested<T> withNewGraphDriverDataLike( GraphDriverData item);    public GraphDriverDataNested<T> editGraphDriverData();    public HostConfig getHostConfig();    public T withHostConfig( HostConfig HostConfig);    public HostConfigNested<T> withNewHostConfig();    public HostConfigNested<T> withNewHostConfigLike( HostConfig item);    public HostConfigNested<T> editHostConfig();    public IPAM getIPAM();    public T withIPAM( IPAM IPAM);    public IPAMNested<T> withNewIPAM();    public IPAMNested<T> withNewIPAMLike( IPAM item);    public IPAMNested<T> editIPAM();    public IPAMConfig getIPAMConfig();    public T withIPAMConfig( IPAMConfig IPAMConfig);    public IPAMConfigNested<T> withNewIPAMConfig();    public IPAMConfigNested<T> withNewIPAMConfigLike( IPAMConfig item);    public IPAMConfigNested<T> editIPAMConfig();    public Image getImage();    public T withImage( Image Image);    public ImageNested<T> withNewImage();    public ImageNested<T> withNewImageLike( Image item);    public ImageNested<T> editImage();    public ImageDelete getImageDelete();    public T withImageDelete( ImageDelete ImageDelete);    public ImageDeleteNested<T> withNewImageDelete();    public ImageDeleteNested<T> withNewImageDeleteLike( ImageDelete item);    public ImageDeleteNested<T> editImageDelete();    public T withNewImageDelete( String Deleted,  String Untagged);    public ImageHistory getImageHistory();    public T withImageHistory( ImageHistory ImageHistory);    public ImageHistoryNested<T> withNewImageHistory();    public ImageHistoryNested<T> withNewImageHistoryLike( ImageHistory item);    public ImageHistoryNested<T> editImageHistory();    public ImageInspect getImageInspect();    public T withImageInspect( ImageInspect ImageInspect);    public ImageInspectNested<T> withNewImageInspect();    public ImageInspectNested<T> withNewImageInspectLike( ImageInspect item);    public ImageInspectNested<T> editImageInspect();    public IndexInfo getIndexInfo();    public T withIndexInfo( IndexInfo IndexInfo);    public IndexInfoNested<T> withNewIndexInfo();    public IndexInfoNested<T> withNewIndexInfoLike( IndexInfo item);    public IndexInfoNested<T> editIndexInfo();    public Info getInfo();    public T withInfo( Info Info);    public InfoNested<T> withNewInfo();    public InfoNested<T> withNewInfoLike( Info item);    public InfoNested<T> editInfo();    public LogConfig getLogConfig();    public T withLogConfig( LogConfig LogConfig);    public LogConfigNested<T> withNewLogConfig();    public LogConfigNested<T> withNewLogConfigLike( LogConfig item);    public LogConfigNested<T> editLogConfig();    public MountPoint getMountPoint();    public T withMountPoint( MountPoint MountPoint);    public MountPointNested<T> withNewMountPoint();    public MountPointNested<T> withNewMountPointLike( MountPoint item);    public MountPointNested<T> editMountPoint();    public NetworkConnect getNetworkConnect();    public T withNetworkConnect( NetworkConnect NetworkConnect);    public NetworkConnectNested<T> withNewNetworkConnect();    public NetworkConnectNested<T> withNewNetworkConnectLike( NetworkConnect item);    public NetworkConnectNested<T> editNetworkConnect();    public T withNewNetworkConnect( String Container);    public NetworkCreate getNetworkCreate();    public T withNetworkCreate( NetworkCreate NetworkCreate);    public NetworkCreateNested<T> withNewNetworkCreate();    public NetworkCreateNested<T> withNewNetworkCreateLike( NetworkCreate item);    public NetworkCreateNested<T> editNetworkCreate();    public NetworkCreateResponse getNetworkCreateResponse();    public T withNetworkCreateResponse( NetworkCreateResponse NetworkCreateResponse);    public NetworkCreateResponseNested<T> withNewNetworkCreateResponse();    public NetworkCreateResponseNested<T> withNewNetworkCreateResponseLike( NetworkCreateResponse item);    public NetworkCreateResponseNested<T> editNetworkCreateResponse();    public T withNewNetworkCreateResponse( String Id,  String Warning);    public NetworkDisconnect getNetworkDisconnect();    public T withNetworkDisconnect( NetworkDisconnect NetworkDisconnect);    public NetworkDisconnectNested<T> withNewNetworkDisconnect();    public NetworkDisconnectNested<T> withNewNetworkDisconnectLike( NetworkDisconnect item);    public NetworkDisconnectNested<T> editNetworkDisconnect();    public T withNewNetworkDisconnect( String Container);    public NetworkResource getNetworkResource();    public T withNetworkResource( NetworkResource NetworkResource);    public NetworkResourceNested<T> withNewNetworkResource();    public NetworkResourceNested<T> withNewNetworkResourceLike( NetworkResource item);    public NetworkResourceNested<T> editNetworkResource();    public NetworkSettings getNetworkSettings();    public T withNetworkSettings( NetworkSettings NetworkSettings);    public NetworkSettingsNested<T> withNewNetworkSettings();    public NetworkSettingsNested<T> withNewNetworkSettingsLike( NetworkSettings item);    public NetworkSettingsNested<T> editNetworkSettings();    public NetworkSettingsBase getNetworkSettingsBase();    public T withNetworkSettingsBase( NetworkSettingsBase NetworkSettingsBase);    public NetworkSettingsBaseNested<T> withNewNetworkSettingsBase();    public NetworkSettingsBaseNested<T> withNewNetworkSettingsBaseLike( NetworkSettingsBase item);    public NetworkSettingsBaseNested<T> editNetworkSettingsBase();    public Port getPort();    public T withPort( Port Port);    public PortNested<T> withNewPort();    public PortNested<T> withNewPortLike( Port item);    public PortNested<T> editPort();    public T withNewPort( String IP,  Integer PrivatePort,  Integer PublicPort,  String Type);    public PortBinding getPortBinding();    public T withPortBinding( PortBinding PortBinding);    public PortBindingNested<T> withNewPortBinding();    public PortBindingNested<T> withNewPortBindingLike( PortBinding item);    public PortBindingNested<T> editPortBinding();    public T withNewPortBinding( String HostIp,  String HostPort);    public SearchResult getSearchResult();    public T withSearchResult( SearchResult SearchResult);    public SearchResultNested<T> withNewSearchResult();    public SearchResultNested<T> withNewSearchResultLike( SearchResult item);    public SearchResultNested<T> editSearchResult();    public SearchResults getSearchResults();    public T withSearchResults( SearchResults SearchResults);    public SearchResultsNested<T> withNewSearchResults();    public SearchResultsNested<T> withNewSearchResultsLike( SearchResults item);    public SearchResultsNested<T> editSearchResults();    public ServiceConfig getServiceConfig();    public T withServiceConfig( ServiceConfig ServiceConfig);    public ServiceConfigNested<T> withNewServiceConfig();    public ServiceConfigNested<T> withNewServiceConfigLike( ServiceConfig item);    public ServiceConfigNested<T> editServiceConfig();    public Stats getStats();    public T withStats( Stats Stats);    public StatsNested<T> withNewStats();    public StatsNested<T> withNewStatsLike( Stats item);    public StatsNested<T> editStats();    public T addToStrSlice( String ...items);    public T removeFromStrSlice( String ...items);    public List<String> getStrSlice();    public T withStrSlice( List<String> StrSlice);    public T withStrSlice( String ...StrSlice);    public Version getVersion();    public T withVersion( Version Version);    public VersionNested<T> withNewVersion();    public VersionNested<T> withNewVersionLike( Version item);    public VersionNested<T> editVersion();    public Volume getVolume();    public T withVolume( Volume Volume);    public VolumeNested<T> withNewVolume();    public VolumeNested<T> withNewVolumeLike( Volume item);    public VolumeNested<T> editVolume();    public T withNewVolume( String Driver,  String Mountpoint,  String Name);    public VolumeCreateRequest getVolumeCreateRequest();    public T withVolumeCreateRequest( VolumeCreateRequest VolumeCreateRequest);    public VolumeCreateRequestNested<T> withNewVolumeCreateRequest();    public VolumeCreateRequestNested<T> withNewVolumeCreateRequestLike( VolumeCreateRequest item);    public VolumeCreateRequestNested<T> editVolumeCreateRequest();    public VolumesListResponse getVolumesListResponse();    public T withVolumesListResponse( VolumesListResponse VolumesListResponse);    public VolumesListResponseNested<T> withNewVolumesListResponse();    public VolumesListResponseNested<T> withNewVolumesListResponseLike( VolumesListResponse item);    public VolumesListResponseNested<T> editVolumesListResponse();    public T addToAdditionalProperties( String key,  Object value);    public T addToAdditionalProperties( Map<String, Object> map);    public T removeFromAdditionalProperties( String key);    public T removeFromAdditionalProperties( Map<String, Object> map);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface AddressNested<N> extends Nested<N>, AddressFluent<AddressNested<N>>{
            public N endAddress();            public N and();        
}

    public interface AuthConfigNested<N> extends Nested<N>, AuthConfigFluent<AuthConfigNested<N>>{
            public N endAuthConfig();            public N and();        
}

    public interface AuthResponseNested<N> extends Nested<N>, AuthResponseFluent<AuthResponseNested<N>>{
            public N and();            public N endAuthResponse();        
}

    public interface ContainerChangeNested<N> extends Nested<N>, ContainerChangeFluent<ContainerChangeNested<N>>{
            public N and();            public N endContainerChange();        
}

    public interface ContainerCommitResponseNested<N> extends Nested<N>, ContainerCommitResponseFluent<ContainerCommitResponseNested<N>>{
            public N and();            public N endContainerCommitResponse();        
}

    public interface ContainerCreateResponseNested<N> extends Nested<N>, ContainerCreateResponseFluent<ContainerCreateResponseNested<N>>{
            public N and();            public N endContainerCreateResponse();        
}

    public interface ContainerExecCreateResponseNested<N> extends Nested<N>, ContainerExecCreateResponseFluent<ContainerExecCreateResponseNested<N>>{
            public N and();            public N endContainerExecCreateResponse();        
}

    public interface ContainerJSONBaseNested<N> extends Nested<N>, ContainerJSONBaseFluent<ContainerJSONBaseNested<N>>{
            public N and();            public N endContainerJSONBase();        
}

    public interface ContainerPathStatNested<N> extends Nested<N>, ContainerPathStatFluent<ContainerPathStatNested<N>>{
            public N endContainerPathStat();            public N and();        
}

    public interface ContainerProcessListNested<N> extends Nested<N>, ContainerProcessListFluent<ContainerProcessListNested<N>>{
            public N endContainerProcessList();            public N and();        
}

    public interface ContainerStateNested<N> extends Nested<N>, ContainerStateFluent<ContainerStateNested<N>>{
            public N endContainerState();            public N and();        
}

    public interface ContainerWaitResponseNested<N> extends Nested<N>, ContainerWaitResponseFluent<ContainerWaitResponseNested<N>>{
            public N and();            public N endContainerWaitResponse();        
}

    public interface CopyConfigNested<N> extends Nested<N>, CopyConfigFluent<CopyConfigNested<N>>{
            public N endCopyConfig();            public N and();        
}

    public interface DefaultNetworkSettingsNested<N> extends Nested<N>, DefaultNetworkSettingsFluent<DefaultNetworkSettingsNested<N>>{
            public N endDefaultNetworkSettings();            public N and();        
}

    public interface EndpointResourceNested<N> extends Nested<N>, EndpointResourceFluent<EndpointResourceNested<N>>{
            public N endEndpointResource();            public N and();        
}

    public interface EndpointSettingsNested<N> extends Nested<N>, EndpointSettingsFluent<EndpointSettingsNested<N>>{
            public N endEndpointSettings();            public N and();        
}

    public interface ExecConfigNested<N> extends Nested<N>, ExecConfigFluent<ExecConfigNested<N>>{
            public N endExecConfig();            public N and();        
}

    public interface ExecStartCheckNested<N> extends Nested<N>, ExecStartCheckFluent<ExecStartCheckNested<N>>{
            public N and();            public N endExecStartCheck();        
}

    public interface GraphDriverDataNested<N> extends Nested<N>, GraphDriverDataFluent<GraphDriverDataNested<N>>{
            public N endGraphDriverData();            public N and();        
}

    public interface HostConfigNested<N> extends Nested<N>, HostConfigFluent<HostConfigNested<N>>{
            public N and();            public N endHostConfig();        
}

    public interface IPAMNested<N> extends Nested<N>, IPAMFluent<IPAMNested<N>>{
            public N endIPAM();            public N and();        
}

    public interface IPAMConfigNested<N> extends Nested<N>, IPAMConfigFluent<IPAMConfigNested<N>>{
            public N endIPAMConfig();            public N and();        
}

    public interface ImageNested<N> extends Nested<N>, ImageFluent<ImageNested<N>>{
            public N and();            public N endImage();        
}

    public interface ImageDeleteNested<N> extends Nested<N>, ImageDeleteFluent<ImageDeleteNested<N>>{
            public N and();            public N endImageDelete();        
}

    public interface ImageHistoryNested<N> extends Nested<N>, ImageHistoryFluent<ImageHistoryNested<N>>{
            public N and();            public N endImageHistory();        
}

    public interface ImageInspectNested<N> extends Nested<N>, ImageInspectFluent<ImageInspectNested<N>>{
            public N and();            public N endImageInspect();        
}

    public interface IndexInfoNested<N> extends Nested<N>, IndexInfoFluent<IndexInfoNested<N>>{
            public N endIndexInfo();            public N and();        
}

    public interface InfoNested<N> extends Nested<N>, InfoFluent<InfoNested<N>>{
            public N and();            public N endInfo();        
}

    public interface LogConfigNested<N> extends Nested<N>, LogConfigFluent<LogConfigNested<N>>{
            public N and();            public N endLogConfig();        
}

    public interface MountPointNested<N> extends Nested<N>, MountPointFluent<MountPointNested<N>>{
            public N endMountPoint();            public N and();        
}

    public interface NetworkConnectNested<N> extends Nested<N>, NetworkConnectFluent<NetworkConnectNested<N>>{
            public N and();            public N endNetworkConnect();        
}

    public interface NetworkCreateNested<N> extends Nested<N>, NetworkCreateFluent<NetworkCreateNested<N>>{
            public N endNetworkCreate();            public N and();        
}

    public interface NetworkCreateResponseNested<N> extends Nested<N>, NetworkCreateResponseFluent<NetworkCreateResponseNested<N>>{
            public N endNetworkCreateResponse();            public N and();        
}

    public interface NetworkDisconnectNested<N> extends Nested<N>, NetworkDisconnectFluent<NetworkDisconnectNested<N>>{
            public N and();            public N endNetworkDisconnect();        
}

    public interface NetworkResourceNested<N> extends Nested<N>, NetworkResourceFluent<NetworkResourceNested<N>>{
            public N and();            public N endNetworkResource();        
}

    public interface NetworkSettingsNested<N> extends Nested<N>, NetworkSettingsFluent<NetworkSettingsNested<N>>{
            public N and();            public N endNetworkSettings();        
}

    public interface NetworkSettingsBaseNested<N> extends Nested<N>, NetworkSettingsBaseFluent<NetworkSettingsBaseNested<N>>{
            public N and();            public N endNetworkSettingsBase();        
}

    public interface PortNested<N> extends Nested<N>, PortFluent<PortNested<N>>{
            public N endPort();            public N and();        
}

    public interface PortBindingNested<N> extends Nested<N>, PortBindingFluent<PortBindingNested<N>>{
            public N and();            public N endPortBinding();        
}

    public interface SearchResultNested<N> extends Nested<N>, SearchResultFluent<SearchResultNested<N>>{
            public N and();            public N endSearchResult();        
}

    public interface SearchResultsNested<N> extends Nested<N>, SearchResultsFluent<SearchResultsNested<N>>{
            public N and();            public N endSearchResults();        
}

    public interface ServiceConfigNested<N> extends Nested<N>, ServiceConfigFluent<ServiceConfigNested<N>>{
            public N and();            public N endServiceConfig();        
}

    public interface StatsNested<N> extends Nested<N>, StatsFluent<StatsNested<N>>{
            public N and();            public N endStats();        
}

    public interface VersionNested<N> extends Nested<N>, VersionFluent<VersionNested<N>>{
            public N and();            public N endVersion();        
}

    public interface VolumeNested<N> extends Nested<N>, VolumeFluent<VolumeNested<N>>{
            public N and();            public N endVolume();        
}

    public interface VolumeCreateRequestNested<N> extends Nested<N>, VolumeCreateRequestFluent<VolumeCreateRequestNested<N>>{
            public N endVolumeCreateRequest();            public N and();        
}

    public interface VolumesListResponseNested<N> extends Nested<N>, VolumesListResponseFluent<VolumesListResponseNested<N>>{
            public N endVolumesListResponse();            public N and();        
}


}
