/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.EditableVersion;
import io.fabric8.docker.api.model.Version;
import io.fabric8.docker.api.model.VersionFluent;
import io.fabric8.docker.api.model.VersionFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class VersionBuilder
extends VersionFluentImpl<VersionBuilder>
implements VisitableBuilder<Version, VersionBuilder> {
    VersionFluent<?> fluent;

    public VersionBuilder() {
        this(new Version());
    }

    public VersionBuilder(VersionFluent<?> fluent) {
        this(fluent, new Version());
    }

    public VersionBuilder(VersionFluent<?> fluent, Version instance) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withArch(instance.getArch());
        fluent.withBuildTime(instance.getBuildTime());
        fluent.withExperimental(instance.getExperimental());
        fluent.withGitCommit(instance.getGitCommit());
        fluent.withGoVersion(instance.getGoVersion());
        fluent.withKernelVersion(instance.getKernelVersion());
        fluent.withOs(instance.getOs());
        fluent.withVersion(instance.getVersion());
    }

    public VersionBuilder(Version instance) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withArch(instance.getArch());
        this.withBuildTime(instance.getBuildTime());
        this.withExperimental(instance.getExperimental());
        this.withGitCommit(instance.getGitCommit());
        this.withGoVersion(instance.getGoVersion());
        this.withKernelVersion(instance.getKernelVersion());
        this.withOs(instance.getOs());
        this.withVersion(instance.getVersion());
    }

    @Override
    public EditableVersion build() {
        EditableVersion buildable = new EditableVersion(this.fluent.getApiVersion(), this.fluent.getArch(), this.fluent.getBuildTime(), this.fluent.isExperimental(), this.fluent.getGitCommit(), this.fluent.getGoVersion(), this.fluent.getKernelVersion(), this.fluent.getOs(), this.fluent.getVersion());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VersionBuilder that = (VersionBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

