/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.ContainerState;
import io.fabric8.docker.api.model.ContainerStateFluent;
import io.fabric8.docker.api.model.ContainerStateFluentImpl;
import io.fabric8.docker.api.model.EditableContainerState;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ContainerStateBuilder
extends ContainerStateFluentImpl<ContainerStateBuilder>
implements VisitableBuilder<ContainerState, ContainerStateBuilder> {
    ContainerStateFluent<?> fluent;

    public ContainerStateBuilder() {
        this(new ContainerState());
    }

    public ContainerStateBuilder(ContainerStateFluent<?> fluent) {
        this(fluent, new ContainerState());
    }

    public ContainerStateBuilder(ContainerStateFluent<?> fluent, ContainerState instance) {
        this.fluent = fluent;
        fluent.withDead(instance.getDead());
        fluent.withError(instance.getError());
        fluent.withExitCode(instance.getExitCode());
        fluent.withFinishedAt(instance.getFinishedAt());
        fluent.withOOMKilled(instance.getOOMKilled());
        fluent.withPaused(instance.getPaused());
        fluent.withPid(instance.getPid());
        fluent.withRestarting(instance.getRestarting());
        fluent.withRunning(instance.getRunning());
        fluent.withStartedAt(instance.getStartedAt());
        fluent.withStatus(instance.getStatus());
    }

    public ContainerStateBuilder(ContainerState instance) {
        this.fluent = this;
        this.withDead(instance.getDead());
        this.withError(instance.getError());
        this.withExitCode(instance.getExitCode());
        this.withFinishedAt(instance.getFinishedAt());
        this.withOOMKilled(instance.getOOMKilled());
        this.withPaused(instance.getPaused());
        this.withPid(instance.getPid());
        this.withRestarting(instance.getRestarting());
        this.withRunning(instance.getRunning());
        this.withStartedAt(instance.getStartedAt());
        this.withStatus(instance.getStatus());
    }

    @Override
    public EditableContainerState build() {
        EditableContainerState buildable = new EditableContainerState(this.fluent.isDead(), this.fluent.getError(), this.fluent.getExitCode(), this.fluent.getFinishedAt(), this.fluent.isOOMKilled(), this.fluent.isPaused(), this.fluent.getPid(), this.fluent.isRestarting(), this.fluent.isRunning(), this.fluent.getStartedAt(), this.fluent.getStatus());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContainerStateBuilder that = (ContainerStateBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

