/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.Container;
import io.fabric8.docker.api.model.ContainerFluent;
import io.fabric8.docker.api.model.ContainerHostConfig;
import io.fabric8.docker.api.model.ContainerHostConfigBuilder;
import io.fabric8.docker.api.model.ContainerHostConfigFluentImpl;
import io.fabric8.docker.api.model.NetworkSettings;
import io.fabric8.docker.api.model.NetworkSettingsBuilder;
import io.fabric8.docker.api.model.NetworkSettingsFluentImpl;
import io.fabric8.docker.api.model.Port;
import io.fabric8.docker.api.model.PortBuilder;
import io.fabric8.docker.api.model.PortFluentImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ContainerFluentImpl<T extends ContainerFluent<T>>
extends BaseFluent<T>
implements ContainerFluent<T> {
    String id;
    List<String> names = new ArrayList<String>();
    String image;
    String imageId;
    String command;
    Long created;
    List<VisitableBuilder<Port, ?>> ports = new ArrayList();
    Long sizeRw;
    Long sizeRootFs;
    Map<String, String> labels = new HashMap<String, String>();
    String status;
    VisitableBuilder<ContainerHostConfig, ?> hostConfig;
    VisitableBuilder<NetworkSettings, ?> summaryNetworkSettings;

    public ContainerFluentImpl() {
    }

    public ContainerFluentImpl(Container instance) {
        this.withId(instance.getId());
        this.withNames(instance.getNames());
        this.withImage(instance.getImage());
        this.withImageId(instance.getImageId());
        this.withCommand(instance.getCommand());
        this.withCreated(instance.getCreated());
        this.withPorts(instance.getPorts());
        this.withSizeRw(instance.getSizeRw());
        this.withSizeRootFs(instance.getSizeRootFs());
        this.withLabels(instance.getLabels());
        this.withStatus(instance.getStatus());
        this.withHostConfig(instance.getHostConfig());
        this.withSummaryNetworkSettings(instance.getSummaryNetworkSettings());
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public T withId(String id) {
        this.id = id;
        return (T)this;
    }

    @Override
    public T addToNames(String ... items) {
        for (String item : items) {
            this.names.add(item);
        }
        return (T)this;
    }

    @Override
    public T removeFromNames(String ... items) {
        for (String item : items) {
            this.names.remove(item);
        }
        return (T)this;
    }

    @Override
    public List<String> getNames() {
        return this.names;
    }

    @Override
    public T withNames(List<String> names) {
        this.names.clear();
        if (names != null) {
            for (String item : names) {
                this.addToNames(item);
            }
        }
        return (T)this;
    }

    @Override
    public T withNames(String ... names) {
        this.names.clear();
        if (names != null) {
            for (String item : names) {
                this.addToNames(item);
            }
        }
        return (T)this;
    }

    @Override
    public String getImage() {
        return this.image;
    }

    @Override
    public T withImage(String image) {
        this.image = image;
        return (T)this;
    }

    @Override
    public String getImageId() {
        return this.imageId;
    }

    @Override
    public T withImageId(String imageId) {
        this.imageId = imageId;
        return (T)this;
    }

    @Override
    public String getCommand() {
        return this.command;
    }

    @Override
    public T withCommand(String command) {
        this.command = command;
        return (T)this;
    }

    @Override
    public Long getCreated() {
        return this.created;
    }

    @Override
    public T withCreated(Long created) {
        this.created = created;
        return (T)this;
    }

    @Override
    public T addToPorts(Port ... items) {
        for (Port item : items) {
            PortBuilder builder = new PortBuilder(item);
            this._visitables.add(builder);
            this.ports.add(builder);
        }
        return (T)this;
    }

    @Override
    public T removeFromPorts(Port ... items) {
        for (Port item : items) {
            PortBuilder builder = new PortBuilder(item);
            this._visitables.remove(builder);
            this.ports.remove(builder);
        }
        return (T)this;
    }

    @Override
    public List<Port> getPorts() {
        return this.build(this.ports);
    }

    @Override
    public T withPorts(List<Port> ports) {
        this.ports.clear();
        if (ports != null) {
            for (Port item : ports) {
                this.addToPorts(item);
            }
        }
        return (T)this;
    }

    @Override
    public T withPorts(Port ... ports) {
        this.ports.clear();
        if (ports != null) {
            for (Port item : ports) {
                this.addToPorts(item);
            }
        }
        return (T)this;
    }

    @Override
    public ContainerFluent.PortsNested<T> addNewPort() {
        return new PortsNestedImpl();
    }

    @Override
    public ContainerFluent.PortsNested<T> addNewPortLike(Port item) {
        return new PortsNestedImpl(item);
    }

    @Override
    public T addNewPort(String IP, Integer PrivatePort, Integer PublicPort, String Type2) {
        return this.addToPorts(new Port(IP, PrivatePort, PublicPort, Type2));
    }

    @Override
    public Long getSizeRw() {
        return this.sizeRw;
    }

    @Override
    public T withSizeRw(Long sizeRw) {
        this.sizeRw = sizeRw;
        return (T)this;
    }

    @Override
    public Long getSizeRootFs() {
        return this.sizeRootFs;
    }

    @Override
    public T withSizeRootFs(Long sizeRootFs) {
        this.sizeRootFs = sizeRootFs;
        return (T)this;
    }

    @Override
    public T addToLabels(String key, String value) {
        if (key != null && value != null) {
            this.labels.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T addToLabels(Map<String, String> map) {
        if (map != null) {
            this.labels.putAll(map);
        }
        return (T)this;
    }

    @Override
    public T removeFromLabels(String key) {
        if (key != null) {
            this.labels.remove(key);
        }
        return (T)this;
    }

    @Override
    public T removeFromLabels(Map<String, String> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.labels.remove(key);
            }
        }
        return (T)this;
    }

    @Override
    public Map<String, String> getLabels() {
        return this.labels;
    }

    @Override
    public T withLabels(Map<String, String> labels) {
        this.labels.clear();
        if (labels != null) {
            this.labels.putAll(labels);
        }
        return (T)this;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public T withStatus(String status) {
        this.status = status;
        return (T)this;
    }

    @Override
    public ContainerHostConfig getHostConfig() {
        return this.hostConfig != null ? (ContainerHostConfig)this.hostConfig.build() : null;
    }

    @Override
    public T withHostConfig(ContainerHostConfig hostConfig) {
        if (hostConfig != null) {
            this.hostConfig = new ContainerHostConfigBuilder(hostConfig);
            this._visitables.add(this.hostConfig);
        }
        return (T)this;
    }

    @Override
    public ContainerFluent.HostConfigNested<T> withNewHostConfig() {
        return new HostConfigNestedImpl();
    }

    @Override
    public ContainerFluent.HostConfigNested<T> withNewHostConfigLike(ContainerHostConfig item) {
        return new HostConfigNestedImpl(item);
    }

    @Override
    public ContainerFluent.HostConfigNested<T> editHostConfig() {
        return this.withNewHostConfigLike(this.getHostConfig());
    }

    @Override
    public T withNewHostConfig(String networkMode) {
        return this.withHostConfig(new ContainerHostConfig(networkMode));
    }

    @Override
    public NetworkSettings getSummaryNetworkSettings() {
        return this.summaryNetworkSettings != null ? (NetworkSettings)this.summaryNetworkSettings.build() : null;
    }

    @Override
    public T withSummaryNetworkSettings(NetworkSettings summaryNetworkSettings) {
        if (summaryNetworkSettings != null) {
            this.summaryNetworkSettings = new NetworkSettingsBuilder(summaryNetworkSettings);
            this._visitables.add(this.summaryNetworkSettings);
        }
        return (T)this;
    }

    @Override
    public ContainerFluent.SummaryNetworkSettingsNested<T> withNewSummaryNetworkSettings() {
        return new SummaryNetworkSettingsNestedImpl();
    }

    @Override
    public ContainerFluent.SummaryNetworkSettingsNested<T> withNewSummaryNetworkSettingsLike(NetworkSettings item) {
        return new SummaryNetworkSettingsNestedImpl(item);
    }

    @Override
    public ContainerFluent.SummaryNetworkSettingsNested<T> editSummaryNetworkSettings() {
        return this.withNewSummaryNetworkSettingsLike(this.getSummaryNetworkSettings());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContainerFluentImpl that = (ContainerFluentImpl)o;
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.names != null ? !this.names.equals(that.names) : that.names != null) {
            return false;
        }
        if (this.image != null ? !this.image.equals(that.image) : that.image != null) {
            return false;
        }
        if (this.imageId != null ? !this.imageId.equals(that.imageId) : that.imageId != null) {
            return false;
        }
        if (this.command != null ? !this.command.equals(that.command) : that.command != null) {
            return false;
        }
        if (this.created != null ? !this.created.equals(that.created) : that.created != null) {
            return false;
        }
        if (this.ports != null ? !this.ports.equals(that.ports) : that.ports != null) {
            return false;
        }
        if (this.sizeRw != null ? !this.sizeRw.equals(that.sizeRw) : that.sizeRw != null) {
            return false;
        }
        if (this.sizeRootFs != null ? !this.sizeRootFs.equals(that.sizeRootFs) : that.sizeRootFs != null) {
            return false;
        }
        if (this.labels != null ? !this.labels.equals(that.labels) : that.labels != null) {
            return false;
        }
        if (this.status != null ? !this.status.equals(that.status) : that.status != null) {
            return false;
        }
        if (this.hostConfig != null ? !this.hostConfig.equals(that.hostConfig) : that.hostConfig != null) {
            return false;
        }
        return !(this.summaryNetworkSettings != null ? !this.summaryNetworkSettings.equals(that.summaryNetworkSettings) : that.summaryNetworkSettings != null);
    }

    public class SummaryNetworkSettingsNestedImpl<N>
    extends NetworkSettingsFluentImpl<ContainerFluent.SummaryNetworkSettingsNested<N>>
    implements ContainerFluent.SummaryNetworkSettingsNested<N> {
        private final NetworkSettingsBuilder builder;

        SummaryNetworkSettingsNestedImpl() {
            this.builder = new NetworkSettingsBuilder(this);
        }

        SummaryNetworkSettingsNestedImpl(NetworkSettings item) {
            this.builder = new NetworkSettingsBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ContainerFluentImpl.this.withSummaryNetworkSettings(this.builder.build());
        }

        @Override
        public N endSummaryNetworkSettings() {
            return this.and();
        }
    }

    public class HostConfigNestedImpl<N>
    extends ContainerHostConfigFluentImpl<ContainerFluent.HostConfigNested<N>>
    implements ContainerFluent.HostConfigNested<N> {
        private final ContainerHostConfigBuilder builder;

        HostConfigNestedImpl() {
            this.builder = new ContainerHostConfigBuilder(this);
        }

        HostConfigNestedImpl(ContainerHostConfig item) {
            this.builder = new ContainerHostConfigBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ContainerFluentImpl.this.withHostConfig(this.builder.build());
        }

        @Override
        public N endHostConfig() {
            return this.and();
        }
    }

    public class PortsNestedImpl<N>
    extends PortFluentImpl<ContainerFluent.PortsNested<N>>
    implements ContainerFluent.PortsNested<N> {
        private final PortBuilder builder;

        PortsNestedImpl() {
            this.builder = new PortBuilder(this);
        }

        PortsNestedImpl(Port item) {
            this.builder = new PortBuilder(this, item);
        }

        @Override
        public N endPort() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)ContainerFluentImpl.this.addToPorts(this.builder.build());
        }
    }
}

