/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.Config;
import io.fabric8.docker.api.model.ConfigFluent;
import io.fabric8.docker.api.model.ConfigFluentImpl;
import io.fabric8.docker.api.model.EditableConfig;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ConfigBuilder
extends ConfigFluentImpl<ConfigBuilder>
implements VisitableBuilder<Config, ConfigBuilder> {
    ConfigFluent<?> fluent;

    public ConfigBuilder() {
        this(new Config());
    }

    public ConfigBuilder(ConfigFluent<?> fluent) {
        this(fluent, new Config());
    }

    public ConfigBuilder(ConfigFluent<?> fluent, Config instance) {
        this.fluent = fluent;
        fluent.withAttachStderr(instance.getAttachStderr());
        fluent.withAttachStdin(instance.getAttachStdin());
        fluent.withAttachStdout(instance.getAttachStdout());
        fluent.withCmd(instance.getCmd());
        fluent.withDomainname(instance.getDomainname());
        fluent.withEntrypoint(instance.getEntrypoint());
        fluent.withEnv(instance.getEnv());
        fluent.withExposedPorts(instance.getExposedPorts());
        fluent.withHostname(instance.getHostname());
        fluent.withImage(instance.getImage());
        fluent.withLabels(instance.getLabels());
        fluent.withMacAddress(instance.getMacAddress());
        fluent.withNetworkDisabled(instance.getNetworkDisabled());
        fluent.withOnBuild(instance.getOnBuild());
        fluent.withOpenStdin(instance.getOpenStdin());
        fluent.withPublishService(instance.getPublishService());
        fluent.withStdinOnce(instance.getStdinOnce());
        fluent.withStopSignal(instance.getStopSignal());
        fluent.withTty(instance.getTty());
        fluent.withUser(instance.getUser());
        fluent.withVolumes(instance.getVolumes());
        fluent.withWorkingDir(instance.getWorkingDir());
    }

    public ConfigBuilder(Config instance) {
        this.fluent = this;
        this.withAttachStderr(instance.getAttachStderr());
        this.withAttachStdin(instance.getAttachStdin());
        this.withAttachStdout(instance.getAttachStdout());
        this.withCmd(instance.getCmd());
        this.withDomainname(instance.getDomainname());
        this.withEntrypoint(instance.getEntrypoint());
        this.withEnv(instance.getEnv());
        this.withExposedPorts(instance.getExposedPorts());
        this.withHostname(instance.getHostname());
        this.withImage(instance.getImage());
        this.withLabels(instance.getLabels());
        this.withMacAddress(instance.getMacAddress());
        this.withNetworkDisabled(instance.getNetworkDisabled());
        this.withOnBuild(instance.getOnBuild());
        this.withOpenStdin(instance.getOpenStdin());
        this.withPublishService(instance.getPublishService());
        this.withStdinOnce(instance.getStdinOnce());
        this.withStopSignal(instance.getStopSignal());
        this.withTty(instance.getTty());
        this.withUser(instance.getUser());
        this.withVolumes(instance.getVolumes());
        this.withWorkingDir(instance.getWorkingDir());
    }

    @Override
    public EditableConfig build() {
        EditableConfig buildable = new EditableConfig(this.fluent.isAttachStderr(), this.fluent.isAttachStdin(), this.fluent.isAttachStdout(), this.fluent.getCmd(), this.fluent.getDomainname(), this.fluent.getEntrypoint(), this.fluent.getEnv(), this.fluent.getExposedPorts(), this.fluent.getHostname(), this.fluent.getImage(), this.fluent.getLabels(), this.fluent.getMacAddress(), this.fluent.isNetworkDisabled(), this.fluent.getOnBuild(), this.fluent.isOpenStdin(), this.fluent.getPublishService(), this.fluent.isStdinOnce(), this.fluent.getStopSignal(), this.fluent.isTty(), this.fluent.getUser(), this.fluent.getVolumes(), this.fluent.getWorkingDir());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConfigBuilder that = (ConfigBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

