/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.AuthConfig;
import io.fabric8.docker.api.model.AuthConfigFluent;
import io.fabric8.docker.api.model.AuthConfigFluentImpl;
import io.fabric8.docker.api.model.EditableAuthConfig;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class AuthConfigBuilder
extends AuthConfigFluentImpl<AuthConfigBuilder>
implements VisitableBuilder<AuthConfig, AuthConfigBuilder> {
    AuthConfigFluent<?> fluent;

    public AuthConfigBuilder() {
        this(new AuthConfig());
    }

    public AuthConfigBuilder(AuthConfigFluent<?> fluent) {
        this(fluent, new AuthConfig());
    }

    public AuthConfigBuilder(AuthConfigFluent<?> fluent, AuthConfig instance) {
        this.fluent = fluent;
        fluent.withAuth(instance.getAuth());
        fluent.withEmail(instance.getEmail());
        fluent.withPassword(instance.getPassword());
        fluent.withServeraddress(instance.getServeraddress());
        fluent.withUsername(instance.getUsername());
    }

    public AuthConfigBuilder(AuthConfig instance) {
        this.fluent = this;
        this.withAuth(instance.getAuth());
        this.withEmail(instance.getEmail());
        this.withPassword(instance.getPassword());
        this.withServeraddress(instance.getServeraddress());
        this.withUsername(instance.getUsername());
    }

    @Override
    public EditableAuthConfig build() {
        EditableAuthConfig buildable = new EditableAuthConfig(this.fluent.getAuth(), this.fluent.getEmail(), this.fluent.getPassword(), this.fluent.getServeraddress(), this.fluent.getUsername());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AuthConfigBuilder that = (AuthConfigBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

