package io.fabric8.docker.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.Map;
import java.util.HashMap;
import java.util.List;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.Builder;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.builder.BaseFluent;
import java.util.List;
import io.fabric8.docker.api.builder.Nested;
import io.fabric8.docker.api.builder.Fluent;

public class ServiceConfigFluentImpl<T extends ServiceConfigFluent<T>> extends BaseFluent<T> implements ServiceConfigFluent<T>{

     Map<String, IndexInfo> IndexConfigs = new HashMap();     List<VisitableBuilder<NetIPNet, ?>> InsecureRegistryCIDRs = new ArrayList();     List<String> Mirrors = new ArrayList();     Map<String, Object> additionalProperties = new HashMap();
public ServiceConfigFluentImpl(){
    
}
public ServiceConfigFluentImpl( ServiceConfig instance ){
    this.withIndexConfigs(instance.getIndexConfigs()); this.withInsecureRegistryCIDRs(instance.getInsecureRegistryCIDRs()); this.withMirrors(instance.getMirrors()); 
}

    public T addToIndexConfigs( String key,  IndexInfo value){
    if(key != null && value != null) {this.IndexConfigs.put(key, value);} return (T)this;
    }
    public T addToIndexConfigs( Map<String, IndexInfo> map){
    if(map != null) { this.IndexConfigs.putAll(map);} return (T)this;
    }
    public T removeFromIndexConfigs( String key){
    if(key != null) {this.IndexConfigs.remove(key);} return (T)this;
    }
    public T removeFromIndexConfigs( Map<String, IndexInfo> map){
    if(map != null) { for(Object key : map.keySet()) {this.IndexConfigs.remove(key);}} return (T)this;
    }
    public Map<String, IndexInfo> getIndexConfigs(){
    return this.IndexConfigs;
    }
    public T withIndexConfigs( Map<String, IndexInfo> IndexConfigs){
    this.IndexConfigs.clear();if (IndexConfigs != null) {this.IndexConfigs.putAll(IndexConfigs);} return (T) this;
    }
    public T addToInsecureRegistryCIDRs( NetIPNet ...items){
    for (NetIPNet item : items) {NetIPNetBuilder builder = new NetIPNetBuilder(item);_visitables.add(builder);this.InsecureRegistryCIDRs.add(builder);} return (T)this;
    }
    public T removeFromInsecureRegistryCIDRs( NetIPNet ...items){
    for (NetIPNet item : items) {NetIPNetBuilder builder = new NetIPNetBuilder(item);_visitables.remove(builder);this.InsecureRegistryCIDRs.remove(builder);} return (T)this;
    }
    public List<NetIPNet> getInsecureRegistryCIDRs(){
    return build(InsecureRegistryCIDRs);
    }
    public T withInsecureRegistryCIDRs( List<NetIPNet> InsecureRegistryCIDRs){
    this.InsecureRegistryCIDRs.clear();if (InsecureRegistryCIDRs != null) {for (NetIPNet item : InsecureRegistryCIDRs){this.addToInsecureRegistryCIDRs(item);}} return (T) this;
    }
    public T withInsecureRegistryCIDRs( NetIPNet ...InsecureRegistryCIDRs){
    this.InsecureRegistryCIDRs.clear(); if (InsecureRegistryCIDRs != null) {for (NetIPNet item :InsecureRegistryCIDRs){ this.addToInsecureRegistryCIDRs(item);}} return (T) this;
    }
    public InsecureRegistryCIDRsNested<T> addNewInsecureRegistryCIDR(){
    return new InsecureRegistryCIDRsNestedImpl<T>();
    }
    public InsecureRegistryCIDRsNested<T> addNewInsecureRegistryCIDRLike( NetIPNet item){
    return new InsecureRegistryCIDRsNestedImpl<T>(item);
    }
    public T addNewInsecureRegistryCIDR( String s){
    return addToInsecureRegistryCIDRs(new NetIPNet(s));
    }
    public T addNewInsecureRegistryCIDR( String ip,  String mask){
    return addToInsecureRegistryCIDRs(new NetIPNet(ip, mask));
    }
    public T addToMirrors( String ...items){
    for (String item : items) {this.Mirrors.add(item);} return (T)this;
    }
    public T removeFromMirrors( String ...items){
    for (String item : items) {this.Mirrors.remove(item);} return (T)this;
    }
    public List<String> getMirrors(){
    return this.Mirrors;
    }
    public T withMirrors( List<String> Mirrors){
    this.Mirrors.clear();if (Mirrors != null) {for (String item : Mirrors){this.addToMirrors(item);}} return (T) this;
    }
    public T withMirrors( String ...Mirrors){
    this.Mirrors.clear(); if (Mirrors != null) {for (String item :Mirrors){ this.addToMirrors(item);}} return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
ServiceConfigFluentImpl that = (ServiceConfigFluentImpl) o;
if (IndexConfigs != null ? !IndexConfigs.equals(that.IndexConfigs) :that.IndexConfigs != null) return false;
if (InsecureRegistryCIDRs != null ? !InsecureRegistryCIDRs.equals(that.InsecureRegistryCIDRs) :that.InsecureRegistryCIDRs != null) return false;
if (Mirrors != null ? !Mirrors.equals(that.Mirrors) :that.Mirrors != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class InsecureRegistryCIDRsNestedImpl<N> extends NetIPNetFluentImpl<InsecureRegistryCIDRsNested<N>> implements InsecureRegistryCIDRsNested<N>{

        private final NetIPNetBuilder builder;
    
             InsecureRegistryCIDRsNestedImpl (){
        this.builder = new NetIPNetBuilder(this);
        }
             InsecureRegistryCIDRsNestedImpl ( NetIPNet item){
        this.builder = new NetIPNetBuilder(this, item);
        }
    
            public N and(){
            return (N) ServiceConfigFluentImpl.this.addToInsecureRegistryCIDRs(builder.build());
        }
            public N endInsecureRegistryCIDR(){
            return and();
        }
    
}


}
