package io.fabric8.docker.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.Builder;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.Fluent;
import io.fabric8.docker.api.builder.VisitableBuilder;

public class MemoryStatsBuilder extends MemoryStatsFluentImpl<MemoryStatsBuilder> implements VisitableBuilder<MemoryStats,MemoryStatsBuilder>{

     MemoryStatsFluent<?> fluent;
public MemoryStatsBuilder(){
    this(new MemoryStats());
}
public MemoryStatsBuilder( MemoryStatsFluent<?> fluent ){
    this(fluent, new MemoryStats());
}
public MemoryStatsBuilder( MemoryStatsFluent<?> fluent , MemoryStats instance ){
    this.fluent = fluent; fluent.withFailcnt(instance.getFailcnt()); fluent.withLimit(instance.getLimit()); fluent.withMaxUsage(instance.getMaxUsage()); fluent.withStats(instance.getStats()); fluent.withUsage(instance.getUsage()); 
}
public MemoryStatsBuilder( MemoryStats instance ){
    this.fluent = this; this.withFailcnt(instance.getFailcnt()); this.withLimit(instance.getLimit()); this.withMaxUsage(instance.getMaxUsage()); this.withStats(instance.getStats()); this.withUsage(instance.getUsage()); 
}

public EditableMemoryStats build(){
    EditableMemoryStats buildable = new EditableMemoryStats(fluent.getFailcnt(),fluent.getLimit(),fluent.getMaxUsage(),fluent.getStats(),fluent.getUsage());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
MemoryStatsBuilder that = (MemoryStatsBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
