package io.fabric8.docker.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.docker.api.builder.Nested;
import io.fabric8.docker.api.builder.Fluent;

public interface ImageInspectFluent<T extends ImageInspectFluent<T>> extends Fluent<T>{


    public String getArchitecture();    public T withArchitecture( String Architecture);    public String getAuthor();    public T withAuthor( String Author);    public String getComment();    public T withComment( String Comment);    public Config getConfig();    public T withConfig( Config Config);    public ConfigNested<T> withNewConfig();    public ConfigNested<T> withNewConfigLike( Config item);    public ConfigNested<T> editConfig();    public String getContainer();    public T withContainer( String Container);    public Config getContainerConfig();    public T withContainerConfig( Config ContainerConfig);    public ContainerConfigNested<T> withNewContainerConfig();    public ContainerConfigNested<T> withNewContainerConfigLike( Config item);    public ContainerConfigNested<T> editContainerConfig();    public String getCreated();    public T withCreated( String Created);    public String getDockerVersion();    public T withDockerVersion( String DockerVersion);    public GraphDriverData getGraphDriver();    public T withGraphDriver( GraphDriverData GraphDriver);    public GraphDriverNested<T> withNewGraphDriver();    public GraphDriverNested<T> withNewGraphDriverLike( GraphDriverData item);    public GraphDriverNested<T> editGraphDriver();    public String getId();    public T withId( String Id);    public String getOs();    public T withOs( String Os);    public String getParent();    public T withParent( String Parent);    public T addToRepoDigests( String ...items);    public T removeFromRepoDigests( String ...items);    public List<String> getRepoDigests();    public T withRepoDigests( List<String> RepoDigests);    public T withRepoDigests( String ...RepoDigests);    public T addToRepoTags( String ...items);    public T removeFromRepoTags( String ...items);    public List<String> getRepoTags();    public T withRepoTags( List<String> RepoTags);    public T withRepoTags( String ...RepoTags);    public Long getSize();    public T withSize( Long Size);    public Long getVirtualSize();    public T withVirtualSize( Long VirtualSize);    public T addToAdditionalProperties( String key,  Object value);    public T addToAdditionalProperties( Map<String, Object> map);    public T removeFromAdditionalProperties( String key);    public T removeFromAdditionalProperties( Map<String, Object> map);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface ConfigNested<N> extends Nested<N>, ConfigFluent<ConfigNested<N>>{
            public N endConfig();            public N and();        
}

    public interface ContainerConfigNested<N> extends Nested<N>, ConfigFluent<ContainerConfigNested<N>>{
            public N endContainerConfig();            public N and();        
}

    public interface GraphDriverNested<N> extends Nested<N>, GraphDriverDataFluent<GraphDriverNested<N>>{
            public N endGraphDriver();            public N and();        
}


}
