package io.fabric8.docker.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.List;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.Builder;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.Fluent;

public class ContainerProcessListBuilder extends ContainerProcessListFluentImpl<ContainerProcessListBuilder> implements VisitableBuilder<ContainerProcessList,ContainerProcessListBuilder>{

     ContainerProcessListFluent<?> fluent;
public ContainerProcessListBuilder(){
    this(new ContainerProcessList());
}
public ContainerProcessListBuilder( ContainerProcessListFluent<?> fluent ){
    this(fluent, new ContainerProcessList());
}
public ContainerProcessListBuilder( ContainerProcessListFluent<?> fluent , ContainerProcessList instance ){
    this.fluent = fluent; fluent.withProcesses(instance.getProcesses()); fluent.withTitles(instance.getTitles()); 
}
public ContainerProcessListBuilder( ContainerProcessList instance ){
    this.fluent = this; this.withProcesses(instance.getProcesses()); this.withTitles(instance.getTitles()); 
}

public EditableContainerProcessList build(){
    EditableContainerProcessList buildable = new EditableContainerProcessList(fluent.getProcesses(),fluent.getTitles());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
ContainerProcessListBuilder that = (ContainerProcessListBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
