package io.fabric8.docker.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.Builder;
import java.util.List;
import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.builder.Nested;
import io.fabric8.docker.api.builder.Fluent;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.VisitableBuilder;

public class ContainerInspectFluentImpl<T extends ContainerInspectFluent<T>> extends ContainerJSONBaseFluentImpl<T> implements ContainerInspectFluent<T>{

     VisitableBuilder<Config, ?> Config;     List<VisitableBuilder<MountPoint, ?>> Mounts = new ArrayList();     VisitableBuilder<NetworkSettings, ?> NetworkSettings;     Map<String, Object> additionalProperties = new HashMap();
public ContainerInspectFluentImpl(){
    
}
public ContainerInspectFluentImpl( ContainerInspect instance ){
    this.withAppArmorProfile(instance.getAppArmorProfile()); this.withArgs(instance.getArgs()); this.withCreated(instance.getCreated()); this.withDriver(instance.getDriver()); this.withExecDriver(instance.getExecDriver()); this.withExecIDs(instance.getExecIDs()); this.withGraphDriver(instance.getGraphDriver()); this.withHostConfig(instance.getHostConfig()); this.withHostnamePath(instance.getHostnamePath()); this.withHostsPath(instance.getHostsPath()); this.withId(instance.getId()); this.withImage(instance.getImage()); this.withLogPath(instance.getLogPath()); this.withMountLabel(instance.getMountLabel()); this.withName(instance.getName()); this.withPath(instance.getPath()); this.withProcessLabel(instance.getProcessLabel()); this.withResolvConfPath(instance.getResolvConfPath()); this.withRestartCount(instance.getRestartCount()); this.withSizeRootFs(instance.getSizeRootFs()); this.withSizeRw(instance.getSizeRw()); this.withState(instance.getState()); this.withConfig(instance.getConfig()); this.withMounts(instance.getMounts()); this.withNetworkSettings(instance.getNetworkSettings()); 
}

    public Config getConfig(){
    return this.Config!=null?this.Config.build():null;
    }
    public T withConfig( Config Config){
    if (Config!=null){ this.Config= new ConfigBuilder(Config); _visitables.add(this.Config);} return (T) this;
    }
    public ConfigNested<T> withNewConfig(){
    return new ConfigNestedImpl<T>();
    }
    public ConfigNested<T> withNewConfigLike( Config item){
    return new ConfigNestedImpl<T>(item);
    }
    public ConfigNested<T> editConfig(){
    return withNewConfigLike(getConfig());
    }
    public T addToMounts( MountPoint ...items){
    for (MountPoint item : items) {MountPointBuilder builder = new MountPointBuilder(item);_visitables.add(builder);this.Mounts.add(builder);} return (T)this;
    }
    public T removeFromMounts( MountPoint ...items){
    for (MountPoint item : items) {MountPointBuilder builder = new MountPointBuilder(item);_visitables.remove(builder);this.Mounts.remove(builder);} return (T)this;
    }
    public List<MountPoint> getMounts(){
    return build(Mounts);
    }
    public T withMounts( List<MountPoint> Mounts){
    this.Mounts.clear();if (Mounts != null) {for (MountPoint item : Mounts){this.addToMounts(item);}} return (T) this;
    }
    public T withMounts( MountPoint ...Mounts){
    this.Mounts.clear(); if (Mounts != null) {for (MountPoint item :Mounts){ this.addToMounts(item);}} return (T) this;
    }
    public MountsNested<T> addNewMount(){
    return new MountsNestedImpl<T>();
    }
    public MountsNested<T> addNewMountLike( MountPoint item){
    return new MountsNestedImpl<T>(item);
    }
    public NetworkSettings getNetworkSettings(){
    return this.NetworkSettings!=null?this.NetworkSettings.build():null;
    }
    public T withNetworkSettings( NetworkSettings NetworkSettings){
    if (NetworkSettings!=null){ this.NetworkSettings= new NetworkSettingsBuilder(NetworkSettings); _visitables.add(this.NetworkSettings);} return (T) this;
    }
    public NetworkSettingsNested<T> withNewNetworkSettings(){
    return new NetworkSettingsNestedImpl<T>();
    }
    public NetworkSettingsNested<T> withNewNetworkSettingsLike( NetworkSettings item){
    return new NetworkSettingsNestedImpl<T>(item);
    }
    public NetworkSettingsNested<T> editNetworkSettings(){
    return withNewNetworkSettingsLike(getNetworkSettings());
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
ContainerInspectFluentImpl that = (ContainerInspectFluentImpl) o;
if (Config != null ? !Config.equals(that.Config) :that.Config != null) return false;
if (Mounts != null ? !Mounts.equals(that.Mounts) :that.Mounts != null) return false;
if (NetworkSettings != null ? !NetworkSettings.equals(that.NetworkSettings) :that.NetworkSettings != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class ConfigNestedImpl<N> extends ConfigFluentImpl<ConfigNested<N>> implements ConfigNested<N>{

        private final ConfigBuilder builder;
    
             ConfigNestedImpl (){
        this.builder = new ConfigBuilder(this);
        }
             ConfigNestedImpl ( Config item){
        this.builder = new ConfigBuilder(this, item);
        }
    
            public N endConfig(){
            return and();
        }
            public N and(){
            return (N) ContainerInspectFluentImpl.this.withConfig(builder.build());
        }
    
}
    public class MountsNestedImpl<N> extends MountPointFluentImpl<MountsNested<N>> implements MountsNested<N>{

        private final MountPointBuilder builder;
    
             MountsNestedImpl (){
        this.builder = new MountPointBuilder(this);
        }
             MountsNestedImpl ( MountPoint item){
        this.builder = new MountPointBuilder(this, item);
        }
    
            public N and(){
            return (N) ContainerInspectFluentImpl.this.addToMounts(builder.build());
        }
            public N endMount(){
            return and();
        }
    
}
    public class NetworkSettingsNestedImpl<N> extends NetworkSettingsFluentImpl<NetworkSettingsNested<N>> implements NetworkSettingsNested<N>{

        private final NetworkSettingsBuilder builder;
    
             NetworkSettingsNestedImpl (){
        this.builder = new NetworkSettingsBuilder(this);
        }
             NetworkSettingsNestedImpl ( NetworkSettings item){
        this.builder = new NetworkSettingsBuilder(this, item);
        }
    
            public N and(){
            return (N) ContainerInspectFluentImpl.this.withNetworkSettings(builder.build());
        }
            public N endNetworkSettings(){
            return and();
        }
    
}


}
