/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.EditableIndexInfo;
import io.fabric8.docker.api.model.IndexInfo;
import io.fabric8.docker.api.model.IndexInfoFluent;
import io.fabric8.docker.api.model.IndexInfoFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class IndexInfoBuilder
extends IndexInfoFluentImpl<IndexInfoBuilder>
implements VisitableBuilder<IndexInfo, IndexInfoBuilder> {
    IndexInfoFluent<?> fluent;

    public IndexInfoBuilder() {
        this(new IndexInfo());
    }

    public IndexInfoBuilder(IndexInfoFluent<?> fluent) {
        this(fluent, new IndexInfo());
    }

    public IndexInfoBuilder(IndexInfoFluent<?> fluent, IndexInfo instance) {
        this.fluent = fluent;
        fluent.withMirrors(instance.getMirrors());
        fluent.withName(instance.getName());
        fluent.withOfficial(instance.getOfficial());
        fluent.withSecure(instance.getSecure());
    }

    public IndexInfoBuilder(IndexInfo instance) {
        this.fluent = this;
        this.withMirrors(instance.getMirrors());
        this.withName(instance.getName());
        this.withOfficial(instance.getOfficial());
        this.withSecure(instance.getSecure());
    }

    @Override
    public EditableIndexInfo build() {
        EditableIndexInfo buildable = new EditableIndexInfo(this.fluent.getMirrors(), this.fluent.getName(), this.fluent.isOfficial(), this.fluent.isSecure());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IndexInfoBuilder that = (IndexInfoBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

