/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.ContainerInspect;
import io.fabric8.docker.api.model.ContainerInspectFluent;
import io.fabric8.docker.api.model.ContainerInspectFluentImpl;
import io.fabric8.docker.api.model.EditableContainerInspect;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ContainerInspectBuilder
extends ContainerInspectFluentImpl<ContainerInspectBuilder>
implements VisitableBuilder<ContainerInspect, ContainerInspectBuilder> {
    ContainerInspectFluent<?> fluent;

    public ContainerInspectBuilder() {
        this(new ContainerInspect());
    }

    public ContainerInspectBuilder(ContainerInspectFluent<?> fluent) {
        this(fluent, new ContainerInspect());
    }

    public ContainerInspectBuilder(ContainerInspectFluent<?> fluent, ContainerInspect instance) {
        this.fluent = fluent;
        fluent.withAppArmorProfile(instance.getAppArmorProfile());
        fluent.withArgs(instance.getArgs());
        fluent.withCreated(instance.getCreated());
        fluent.withDriver(instance.getDriver());
        fluent.withExecDriver(instance.getExecDriver());
        fluent.withExecIDs(instance.getExecIDs());
        fluent.withGraphDriver(instance.getGraphDriver());
        fluent.withHostConfig(instance.getHostConfig());
        fluent.withHostnamePath(instance.getHostnamePath());
        fluent.withHostsPath(instance.getHostsPath());
        fluent.withId(instance.getId());
        fluent.withImage(instance.getImage());
        fluent.withLogPath(instance.getLogPath());
        fluent.withMountLabel(instance.getMountLabel());
        fluent.withName(instance.getName());
        fluent.withPath(instance.getPath());
        fluent.withProcessLabel(instance.getProcessLabel());
        fluent.withResolvConfPath(instance.getResolvConfPath());
        fluent.withRestartCount(instance.getRestartCount());
        fluent.withSizeRootFs(instance.getSizeRootFs());
        fluent.withSizeRw(instance.getSizeRw());
        fluent.withState(instance.getState());
        fluent.withConfig(instance.getConfig());
        fluent.withMounts(instance.getMounts());
        fluent.withNetworkSettings(instance.getNetworkSettings());
    }

    public ContainerInspectBuilder(ContainerInspect instance) {
        this.fluent = this;
        this.withAppArmorProfile(instance.getAppArmorProfile());
        this.withArgs(instance.getArgs());
        this.withCreated(instance.getCreated());
        this.withDriver(instance.getDriver());
        this.withExecDriver(instance.getExecDriver());
        this.withExecIDs(instance.getExecIDs());
        this.withGraphDriver(instance.getGraphDriver());
        this.withHostConfig(instance.getHostConfig());
        this.withHostnamePath(instance.getHostnamePath());
        this.withHostsPath(instance.getHostsPath());
        this.withId(instance.getId());
        this.withImage(instance.getImage());
        this.withLogPath(instance.getLogPath());
        this.withMountLabel(instance.getMountLabel());
        this.withName(instance.getName());
        this.withPath(instance.getPath());
        this.withProcessLabel(instance.getProcessLabel());
        this.withResolvConfPath(instance.getResolvConfPath());
        this.withRestartCount(instance.getRestartCount());
        this.withSizeRootFs(instance.getSizeRootFs());
        this.withSizeRw(instance.getSizeRw());
        this.withState(instance.getState());
        this.withConfig(instance.getConfig());
        this.withMounts(instance.getMounts());
        this.withNetworkSettings(instance.getNetworkSettings());
    }

    @Override
    public EditableContainerInspect build() {
        EditableContainerInspect buildable = new EditableContainerInspect(this.fluent.getAppArmorProfile(), this.fluent.getArgs(), this.fluent.getCreated(), this.fluent.getDriver(), this.fluent.getExecDriver(), this.fluent.getExecIDs(), this.fluent.getGraphDriver(), this.fluent.getHostConfig(), this.fluent.getHostnamePath(), this.fluent.getHostsPath(), this.fluent.getId(), this.fluent.getImage(), this.fluent.getLogPath(), this.fluent.getMountLabel(), this.fluent.getName(), this.fluent.getPath(), this.fluent.getProcessLabel(), this.fluent.getResolvConfPath(), this.fluent.getRestartCount(), this.fluent.getSizeRootFs(), this.fluent.getSizeRw(), this.fluent.getState(), this.fluent.getConfig(), this.fluent.getMounts(), this.fluent.getNetworkSettings());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContainerInspectBuilder that = (ContainerInspectBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

