/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.BlkioStatEntry;
import io.fabric8.docker.api.model.BlkioStatEntryFluent;
import io.fabric8.docker.api.model.BlkioStatEntryFluentImpl;
import io.fabric8.docker.api.model.EditableBlkioStatEntry;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class BlkioStatEntryBuilder
extends BlkioStatEntryFluentImpl<BlkioStatEntryBuilder>
implements VisitableBuilder<BlkioStatEntry, BlkioStatEntryBuilder> {
    BlkioStatEntryFluent<?> fluent;

    public BlkioStatEntryBuilder() {
        this(new BlkioStatEntry());
    }

    public BlkioStatEntryBuilder(BlkioStatEntryFluent<?> fluent) {
        this(fluent, new BlkioStatEntry());
    }

    public BlkioStatEntryBuilder(BlkioStatEntryFluent<?> fluent, BlkioStatEntry instance) {
        this.fluent = fluent;
        fluent.withMajor(instance.getMajor());
        fluent.withMinor(instance.getMinor());
        fluent.withOp(instance.getOp());
        fluent.withValue(instance.getValue());
    }

    public BlkioStatEntryBuilder(BlkioStatEntry instance) {
        this.fluent = this;
        this.withMajor(instance.getMajor());
        this.withMinor(instance.getMinor());
        this.withOp(instance.getOp());
        this.withValue(instance.getValue());
    }

    @Override
    public EditableBlkioStatEntry build() {
        EditableBlkioStatEntry buildable = new EditableBlkioStatEntry(this.fluent.getMajor(), this.fluent.getMinor(), this.fluent.getOp(), this.fluent.getValue());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BlkioStatEntryBuilder that = (BlkioStatEntryBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

