package io.fabric8.docker.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.AbstractMap;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.Builder;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.VisitableBuilder;
import java.util.List;
import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.Nested;
import io.fabric8.docker.api.builder.Fluent;

public class VolumesListResponseFluentImpl<T extends VolumesListResponseFluent<T>> extends BaseFluent<T> implements VolumesListResponseFluent<T>{

     List<VisitableBuilder<Volume, ?>> Volumes = new ArrayList();     Map<String, Object> additionalProperties = new HashMap();
public VolumesListResponseFluentImpl(){
    
}
public VolumesListResponseFluentImpl( VolumesListResponse instance ){
    this.withVolumes(instance.getVolumes()); 
}

    public T addToVolumes( Volume ...items){
    for (Volume item : items) {VolumeBuilder builder = new VolumeBuilder(item);_visitables.add(builder);this.Volumes.add(builder);} return (T)this;
    }
    public T removeFromVolumes( Volume ...items){
    for (Volume item : items) {VolumeBuilder builder = new VolumeBuilder(item);_visitables.remove(builder);this.Volumes.remove(builder);} return (T)this;
    }
    public List<Volume> getVolumes(){
    return build(Volumes);
    }
    public T withVolumes( List<Volume> Volumes){
    this.Volumes.clear();if (Volumes != null) {for (Volume item : Volumes){this.addToVolumes(item);}} return (T) this;
    }
    public T withVolumes( Volume ...Volumes){
    this.Volumes.clear(); if (Volumes != null) {for (Volume item :Volumes){ this.addToVolumes(item);}} return (T) this;
    }
    public VolumesNested<T> addNewVolume(){
    return new VolumesNestedImpl<T>();
    }
    public VolumesNested<T> addNewVolumeLike( Volume item){
    return new VolumesNestedImpl<T>(item);
    }
    public T addNewVolume( String Driver,  String Mountpoint,  String Name){
    return addToVolumes(new Volume(Driver, Mountpoint, Name));
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
VolumesListResponseFluentImpl that = (VolumesListResponseFluentImpl) o;
if (Volumes != null ? !Volumes.equals(that.Volumes) :that.Volumes != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class VolumesNestedImpl<N> extends VolumeFluentImpl<VolumesNested<N>> implements VolumesNested<N>{

        private final VolumeBuilder builder;
    
             VolumesNestedImpl (){
        this.builder = new VolumeBuilder(this);
        }
             VolumesNestedImpl ( Volume item){
        this.builder = new VolumeBuilder(this, item);
        }
    
            public N and(){
            return (N) VolumesListResponseFluentImpl.this.addToVolumes(builder.build());
        }
            public N endVolume(){
            return and();
        }
    
}


}
