package io.fabric8.docker.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.AbstractCollection;
import java.util.List;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.Builder;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.builder.Fluent;

public class SearchResultsBuilder extends SearchResultsFluentImpl<SearchResultsBuilder> implements VisitableBuilder<SearchResults,SearchResultsBuilder>{

     SearchResultsFluent<?> fluent;
public SearchResultsBuilder(){
    this(new SearchResults());
}
public SearchResultsBuilder( SearchResultsFluent<?> fluent ){
    this(fluent, new SearchResults());
}
public SearchResultsBuilder( SearchResultsFluent<?> fluent , SearchResults instance ){
    this.fluent = fluent; fluent.withNumResults(instance.getNumResults()); fluent.withQuery(instance.getQuery()); fluent.withResults(instance.getResults()); 
}
public SearchResultsBuilder( SearchResults instance ){
    this.fluent = this; this.withNumResults(instance.getNumResults()); this.withQuery(instance.getQuery()); this.withResults(instance.getResults()); 
}

public EditableSearchResults build(){
    EditableSearchResults buildable = new EditableSearchResults(fluent.getNumResults(),fluent.getQuery(),fluent.getResults());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
SearchResultsBuilder that = (SearchResultsBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
