package io.fabric8.docker.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.Builder;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.Fluent;

public class NetworkDisconnectBuilder extends NetworkDisconnectFluentImpl<NetworkDisconnectBuilder> implements VisitableBuilder<NetworkDisconnect,NetworkDisconnectBuilder>{

     NetworkDisconnectFluent<?> fluent;
public NetworkDisconnectBuilder(){
    this(new NetworkDisconnect());
}
public NetworkDisconnectBuilder( NetworkDisconnectFluent<?> fluent ){
    this(fluent, new NetworkDisconnect());
}
public NetworkDisconnectBuilder( NetworkDisconnectFluent<?> fluent , NetworkDisconnect instance ){
    this.fluent = fluent; fluent.withContainer(instance.getContainer()); 
}
public NetworkDisconnectBuilder( NetworkDisconnect instance ){
    this.fluent = this; this.withContainer(instance.getContainer()); 
}

public EditableNetworkDisconnect build(){
    EditableNetworkDisconnect buildable = new EditableNetworkDisconnect(fluent.getContainer());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
NetworkDisconnectBuilder that = (NetworkDisconnectBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
