package io.fabric8.docker.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.Builder;
import io.fabric8.docker.api.builder.Nested;
import io.fabric8.docker.api.builder.Fluent;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.builder.BaseFluent;

public class ImageInspectFluentImpl<T extends ImageInspectFluent<T>> extends BaseFluent<T> implements ImageInspectFluent<T>{

     String Architecture;     String Author;     String Comment;     VisitableBuilder<Config, ?> Config;     String Container;     VisitableBuilder<Config, ?> ContainerConfig;     String Created;     String DockerVersion;     VisitableBuilder<GraphDriverData, ?> GraphDriver;     String Id;     String Os;     String Parent;     List<String> RepoDigests = new ArrayList();     List<String> RepoTags = new ArrayList();     Long Size;     Long VirtualSize;     Map<String, Object> additionalProperties = new HashMap();
public ImageInspectFluentImpl(){
    
}
public ImageInspectFluentImpl( ImageInspect instance ){
    this.withArchitecture(instance.getArchitecture()); this.withAuthor(instance.getAuthor()); this.withComment(instance.getComment()); this.withConfig(instance.getConfig()); this.withContainer(instance.getContainer()); this.withContainerConfig(instance.getContainerConfig()); this.withCreated(instance.getCreated()); this.withDockerVersion(instance.getDockerVersion()); this.withGraphDriver(instance.getGraphDriver()); this.withId(instance.getId()); this.withOs(instance.getOs()); this.withParent(instance.getParent()); this.withRepoDigests(instance.getRepoDigests()); this.withRepoTags(instance.getRepoTags()); this.withSize(instance.getSize()); this.withVirtualSize(instance.getVirtualSize()); 
}

    public String getArchitecture(){
    return this.Architecture;
    }
    public T withArchitecture( String Architecture){
    this.Architecture=Architecture; return (T) this;
    }
    public String getAuthor(){
    return this.Author;
    }
    public T withAuthor( String Author){
    this.Author=Author; return (T) this;
    }
    public String getComment(){
    return this.Comment;
    }
    public T withComment( String Comment){
    this.Comment=Comment; return (T) this;
    }
    public Config getConfig(){
    return this.Config!=null?this.Config.build():null;
    }
    public T withConfig( Config Config){
    if (Config!=null){ this.Config= new ConfigBuilder(Config); _visitables.add(this.Config);} return (T) this;
    }
    public ConfigNested<T> withNewConfig(){
    return new ConfigNestedImpl<T>();
    }
    public ConfigNested<T> withNewConfigLike( Config item){
    return new ConfigNestedImpl<T>(item);
    }
    public ConfigNested<T> editConfig(){
    return withNewConfigLike(getConfig());
    }
    public String getContainer(){
    return this.Container;
    }
    public T withContainer( String Container){
    this.Container=Container; return (T) this;
    }
    public Config getContainerConfig(){
    return this.ContainerConfig!=null?this.ContainerConfig.build():null;
    }
    public T withContainerConfig( Config ContainerConfig){
    if (ContainerConfig!=null){ this.ContainerConfig= new ConfigBuilder(ContainerConfig); _visitables.add(this.ContainerConfig);} return (T) this;
    }
    public ContainerConfigNested<T> withNewContainerConfig(){
    return new ContainerConfigNestedImpl<T>();
    }
    public ContainerConfigNested<T> withNewContainerConfigLike( Config item){
    return new ContainerConfigNestedImpl<T>(item);
    }
    public ContainerConfigNested<T> editContainerConfig(){
    return withNewContainerConfigLike(getContainerConfig());
    }
    public String getCreated(){
    return this.Created;
    }
    public T withCreated( String Created){
    this.Created=Created; return (T) this;
    }
    public String getDockerVersion(){
    return this.DockerVersion;
    }
    public T withDockerVersion( String DockerVersion){
    this.DockerVersion=DockerVersion; return (T) this;
    }
    public GraphDriverData getGraphDriver(){
    return this.GraphDriver!=null?this.GraphDriver.build():null;
    }
    public T withGraphDriver( GraphDriverData GraphDriver){
    if (GraphDriver!=null){ this.GraphDriver= new GraphDriverDataBuilder(GraphDriver); _visitables.add(this.GraphDriver);} return (T) this;
    }
    public GraphDriverNested<T> withNewGraphDriver(){
    return new GraphDriverNestedImpl<T>();
    }
    public GraphDriverNested<T> withNewGraphDriverLike( GraphDriverData item){
    return new GraphDriverNestedImpl<T>(item);
    }
    public GraphDriverNested<T> editGraphDriver(){
    return withNewGraphDriverLike(getGraphDriver());
    }
    public String getId(){
    return this.Id;
    }
    public T withId( String Id){
    this.Id=Id; return (T) this;
    }
    public String getOs(){
    return this.Os;
    }
    public T withOs( String Os){
    this.Os=Os; return (T) this;
    }
    public String getParent(){
    return this.Parent;
    }
    public T withParent( String Parent){
    this.Parent=Parent; return (T) this;
    }
    public T addToRepoDigests( String ...items){
    for (String item : items) {this.RepoDigests.add(item);} return (T)this;
    }
    public T removeFromRepoDigests( String ...items){
    for (String item : items) {this.RepoDigests.remove(item);} return (T)this;
    }
    public List<String> getRepoDigests(){
    return this.RepoDigests;
    }
    public T withRepoDigests( List<String> RepoDigests){
    this.RepoDigests.clear();if (RepoDigests != null) {for (String item : RepoDigests){this.addToRepoDigests(item);}} return (T) this;
    }
    public T withRepoDigests( String ...RepoDigests){
    this.RepoDigests.clear(); if (RepoDigests != null) {for (String item :RepoDigests){ this.addToRepoDigests(item);}} return (T) this;
    }
    public T addToRepoTags( String ...items){
    for (String item : items) {this.RepoTags.add(item);} return (T)this;
    }
    public T removeFromRepoTags( String ...items){
    for (String item : items) {this.RepoTags.remove(item);} return (T)this;
    }
    public List<String> getRepoTags(){
    return this.RepoTags;
    }
    public T withRepoTags( List<String> RepoTags){
    this.RepoTags.clear();if (RepoTags != null) {for (String item : RepoTags){this.addToRepoTags(item);}} return (T) this;
    }
    public T withRepoTags( String ...RepoTags){
    this.RepoTags.clear(); if (RepoTags != null) {for (String item :RepoTags){ this.addToRepoTags(item);}} return (T) this;
    }
    public Long getSize(){
    return this.Size;
    }
    public T withSize( Long Size){
    this.Size=Size; return (T) this;
    }
    public Long getVirtualSize(){
    return this.VirtualSize;
    }
    public T withVirtualSize( Long VirtualSize){
    this.VirtualSize=VirtualSize; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
ImageInspectFluentImpl that = (ImageInspectFluentImpl) o;
if (Architecture != null ? !Architecture.equals(that.Architecture) :that.Architecture != null) return false;
if (Author != null ? !Author.equals(that.Author) :that.Author != null) return false;
if (Comment != null ? !Comment.equals(that.Comment) :that.Comment != null) return false;
if (Config != null ? !Config.equals(that.Config) :that.Config != null) return false;
if (Container != null ? !Container.equals(that.Container) :that.Container != null) return false;
if (ContainerConfig != null ? !ContainerConfig.equals(that.ContainerConfig) :that.ContainerConfig != null) return false;
if (Created != null ? !Created.equals(that.Created) :that.Created != null) return false;
if (DockerVersion != null ? !DockerVersion.equals(that.DockerVersion) :that.DockerVersion != null) return false;
if (GraphDriver != null ? !GraphDriver.equals(that.GraphDriver) :that.GraphDriver != null) return false;
if (Id != null ? !Id.equals(that.Id) :that.Id != null) return false;
if (Os != null ? !Os.equals(that.Os) :that.Os != null) return false;
if (Parent != null ? !Parent.equals(that.Parent) :that.Parent != null) return false;
if (RepoDigests != null ? !RepoDigests.equals(that.RepoDigests) :that.RepoDigests != null) return false;
if (RepoTags != null ? !RepoTags.equals(that.RepoTags) :that.RepoTags != null) return false;
if (Size != null ? !Size.equals(that.Size) :that.Size != null) return false;
if (VirtualSize != null ? !VirtualSize.equals(that.VirtualSize) :that.VirtualSize != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class ConfigNestedImpl<N> extends ConfigFluentImpl<ConfigNested<N>> implements ConfigNested<N>{

        private final ConfigBuilder builder;
    
             ConfigNestedImpl (){
        this.builder = new ConfigBuilder(this);
        }
             ConfigNestedImpl ( Config item){
        this.builder = new ConfigBuilder(this, item);
        }
    
            public N endConfig(){
            return and();
        }
            public N and(){
            return (N) ImageInspectFluentImpl.this.withConfig(builder.build());
        }
    
}
    public class ContainerConfigNestedImpl<N> extends ConfigFluentImpl<ContainerConfigNested<N>> implements ContainerConfigNested<N>{

        private final ConfigBuilder builder;
    
             ContainerConfigNestedImpl (){
        this.builder = new ConfigBuilder(this);
        }
             ContainerConfigNestedImpl ( Config item){
        this.builder = new ConfigBuilder(this, item);
        }
    
            public N endContainerConfig(){
            return and();
        }
            public N and(){
            return (N) ImageInspectFluentImpl.this.withContainerConfig(builder.build());
        }
    
}
    public class GraphDriverNestedImpl<N> extends GraphDriverDataFluentImpl<GraphDriverNested<N>> implements GraphDriverNested<N>{

        private final GraphDriverDataBuilder builder;
    
             GraphDriverNestedImpl (){
        this.builder = new GraphDriverDataBuilder(this);
        }
             GraphDriverNestedImpl ( GraphDriverData item){
        this.builder = new GraphDriverDataBuilder(this, item);
        }
    
            public N endGraphDriver(){
            return and();
        }
            public N and(){
            return (N) ImageInspectFluentImpl.this.withGraphDriver(builder.build());
        }
    
}


}
