package io.fabric8.docker.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.Builder;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.builder.Fluent;

public class ImageInspectBuilder extends ImageInspectFluentImpl<ImageInspectBuilder> implements VisitableBuilder<ImageInspect,ImageInspectBuilder>{

     ImageInspectFluent<?> fluent;
public ImageInspectBuilder(){
    this(new ImageInspect());
}
public ImageInspectBuilder( ImageInspectFluent<?> fluent ){
    this(fluent, new ImageInspect());
}
public ImageInspectBuilder( ImageInspectFluent<?> fluent , ImageInspect instance ){
    this.fluent = fluent; fluent.withArchitecture(instance.getArchitecture()); fluent.withAuthor(instance.getAuthor()); fluent.withComment(instance.getComment()); fluent.withConfig(instance.getConfig()); fluent.withContainer(instance.getContainer()); fluent.withContainerConfig(instance.getContainerConfig()); fluent.withCreated(instance.getCreated()); fluent.withDockerVersion(instance.getDockerVersion()); fluent.withGraphDriver(instance.getGraphDriver()); fluent.withId(instance.getId()); fluent.withOs(instance.getOs()); fluent.withParent(instance.getParent()); fluent.withRepoDigests(instance.getRepoDigests()); fluent.withRepoTags(instance.getRepoTags()); fluent.withSize(instance.getSize()); fluent.withVirtualSize(instance.getVirtualSize()); 
}
public ImageInspectBuilder( ImageInspect instance ){
    this.fluent = this; this.withArchitecture(instance.getArchitecture()); this.withAuthor(instance.getAuthor()); this.withComment(instance.getComment()); this.withConfig(instance.getConfig()); this.withContainer(instance.getContainer()); this.withContainerConfig(instance.getContainerConfig()); this.withCreated(instance.getCreated()); this.withDockerVersion(instance.getDockerVersion()); this.withGraphDriver(instance.getGraphDriver()); this.withId(instance.getId()); this.withOs(instance.getOs()); this.withParent(instance.getParent()); this.withRepoDigests(instance.getRepoDigests()); this.withRepoTags(instance.getRepoTags()); this.withSize(instance.getSize()); this.withVirtualSize(instance.getVirtualSize()); 
}

public EditableImageInspect build(){
    EditableImageInspect buildable = new EditableImageInspect(fluent.getArchitecture(),fluent.getAuthor(),fluent.getComment(),fluent.getConfig(),fluent.getContainer(),fluent.getContainerConfig(),fluent.getCreated(),fluent.getDockerVersion(),fluent.getGraphDriver(),fluent.getId(),fluent.getOs(),fluent.getParent(),fluent.getRepoDigests(),fluent.getRepoTags(),fluent.getSize(),fluent.getVirtualSize());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
ImageInspectBuilder that = (ImageInspectBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
