package io.fabric8.docker.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.Builder;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.Fluent;

public class ExecConfigBuilder extends ExecConfigFluentImpl<ExecConfigBuilder> implements VisitableBuilder<ExecConfig,ExecConfigBuilder>{

     ExecConfigFluent<?> fluent;
public ExecConfigBuilder(){
    this(new ExecConfig());
}
public ExecConfigBuilder( ExecConfigFluent<?> fluent ){
    this(fluent, new ExecConfig());
}
public ExecConfigBuilder( ExecConfigFluent<?> fluent , ExecConfig instance ){
    this.fluent = fluent; fluent.withAttachStderr(instance.getAttachStderr()); fluent.withAttachStdin(instance.getAttachStdin()); fluent.withAttachStdout(instance.getAttachStdout()); fluent.withCmd(instance.getCmd()); fluent.withContainer(instance.getContainer()); fluent.withDetach(instance.getDetach()); fluent.withPrivileged(instance.getPrivileged()); fluent.withTty(instance.getTty()); fluent.withUser(instance.getUser()); 
}
public ExecConfigBuilder( ExecConfig instance ){
    this.fluent = this; this.withAttachStderr(instance.getAttachStderr()); this.withAttachStdin(instance.getAttachStdin()); this.withAttachStdout(instance.getAttachStdout()); this.withCmd(instance.getCmd()); this.withContainer(instance.getContainer()); this.withDetach(instance.getDetach()); this.withPrivileged(instance.getPrivileged()); this.withTty(instance.getTty()); this.withUser(instance.getUser()); 
}

public EditableExecConfig build(){
    EditableExecConfig buildable = new EditableExecConfig(fluent.isAttachStderr(),fluent.isAttachStdin(),fluent.isAttachStdout(),fluent.getCmd(),fluent.getContainer(),fluent.isDetach(),fluent.isPrivileged(),fluent.isTty(),fluent.getUser());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
ExecConfigBuilder that = (ExecConfigBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
