package io.fabric8.docker.api.model;

import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.docker.api.builder.Nested;
import io.fabric8.docker.api.builder.Fluent;

public interface StatsFluent<T extends StatsFluent<T>> extends Fluent<T>{


    public BlkioStats getBlkioStats();    public T withBlkioStats( BlkioStats blkioStats);    public BlkioStatsNested<T> withNewBlkioStats();    public BlkioStatsNested<T> withNewBlkioStatsLike( BlkioStats item);    public BlkioStatsNested<T> editBlkioStats();    public CPUStats getCpuStats();    public T withCpuStats( CPUStats cpuStats);    public CpuStatsNested<T> withNewCpuStats();    public CpuStatsNested<T> withNewCpuStatsLike( CPUStats item);    public CpuStatsNested<T> editCpuStats();    public MemoryStats getMemoryStats();    public T withMemoryStats( MemoryStats memoryStats);    public MemoryStatsNested<T> withNewMemoryStats();    public MemoryStatsNested<T> withNewMemoryStatsLike( MemoryStats item);    public MemoryStatsNested<T> editMemoryStats();    public CPUStats getPrecpuStats();    public T withPrecpuStats( CPUStats precpuStats);    public PrecpuStatsNested<T> withNewPrecpuStats();    public PrecpuStatsNested<T> withNewPrecpuStatsLike( CPUStats item);    public PrecpuStatsNested<T> editPrecpuStats();    public String getRead();    public T withRead( String read);    public T addToAdditionalProperties( String key,  Object value);    public T addToAdditionalProperties( Map<String, Object> map);    public T removeFromAdditionalProperties( String key);    public T removeFromAdditionalProperties( Map<String, Object> map);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface BlkioStatsNested<N> extends Nested<N>, BlkioStatsFluent<BlkioStatsNested<N>>{
            public N endBlkioStats();            public N and();        
}

    public interface CpuStatsNested<N> extends Nested<N>, CPUStatsFluent<CpuStatsNested<N>>{
            public N and();            public N endCpuStats();        
}

    public interface MemoryStatsNested<N> extends Nested<N>, MemoryStatsFluent<MemoryStatsNested<N>>{
            public N and();            public N endMemoryStats();        
}

    public interface PrecpuStatsNested<N> extends Nested<N>, CPUStatsFluent<PrecpuStatsNested<N>>{
            public N endPrecpuStats();            public N and();        
}


}
