package io.fabric8.docker.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.Builder;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.Fluent;

public class MountPointBuilder extends MountPointFluentImpl<MountPointBuilder> implements VisitableBuilder<MountPoint,MountPointBuilder>{

     MountPointFluent<?> fluent;
public MountPointBuilder(){
    this(new MountPoint());
}
public MountPointBuilder( MountPointFluent<?> fluent ){
    this(fluent, new MountPoint());
}
public MountPointBuilder( MountPointFluent<?> fluent , MountPoint instance ){
    this.fluent = fluent; fluent.withDestination(instance.getDestination()); fluent.withDriver(instance.getDriver()); fluent.withMode(instance.getMode()); fluent.withName(instance.getName()); fluent.withRW(instance.getRW()); fluent.withSource(instance.getSource()); 
}
public MountPointBuilder( MountPoint instance ){
    this.fluent = this; this.withDestination(instance.getDestination()); this.withDriver(instance.getDriver()); this.withMode(instance.getMode()); this.withName(instance.getName()); this.withRW(instance.getRW()); this.withSource(instance.getSource()); 
}

public EditableMountPoint build(){
    EditableMountPoint buildable = new EditableMountPoint(fluent.getDestination(),fluent.getDriver(),fluent.getMode(),fluent.getName(),fluent.isRW(),fluent.getSource());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
MountPointBuilder that = (MountPointBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
