package io.fabric8.docker.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.Fluent;

public class ExecConfigFluentImpl<T extends ExecConfigFluent<T>> extends BaseFluent<T> implements ExecConfigFluent<T>{

     Boolean AttachStderr;     Boolean AttachStdin;     Boolean AttachStdout;     List<String> Cmd = new ArrayList();     String Container;     Boolean Detach;     Boolean Privileged;     Boolean Tty;     String User;     Map<String, Object> additionalProperties = new HashMap();
public ExecConfigFluentImpl(){
    
}
public ExecConfigFluentImpl( ExecConfig instance ){
    this.withAttachStderr(instance.getAttachStderr()); this.withAttachStdin(instance.getAttachStdin()); this.withAttachStdout(instance.getAttachStdout()); this.withCmd(instance.getCmd()); this.withContainer(instance.getContainer()); this.withDetach(instance.getDetach()); this.withPrivileged(instance.getPrivileged()); this.withTty(instance.getTty()); this.withUser(instance.getUser()); 
}

    public Boolean isAttachStderr(){
    return this.AttachStderr;
    }
    public T withAttachStderr( Boolean AttachStderr){
    this.AttachStderr=AttachStderr; return (T) this;
    }
    public Boolean isAttachStdin(){
    return this.AttachStdin;
    }
    public T withAttachStdin( Boolean AttachStdin){
    this.AttachStdin=AttachStdin; return (T) this;
    }
    public Boolean isAttachStdout(){
    return this.AttachStdout;
    }
    public T withAttachStdout( Boolean AttachStdout){
    this.AttachStdout=AttachStdout; return (T) this;
    }
    public T addToCmd( String ...items){
    for (String item : items) {this.Cmd.add(item);} return (T)this;
    }
    public T removeFromCmd( String ...items){
    for (String item : items) {this.Cmd.remove(item);} return (T)this;
    }
    public List<String> getCmd(){
    return this.Cmd;
    }
    public T withCmd( List<String> Cmd){
    this.Cmd.clear();if (Cmd != null) {for (String item : Cmd){this.addToCmd(item);}} return (T) this;
    }
    public T withCmd( String ...Cmd){
    this.Cmd.clear(); if (Cmd != null) {for (String item :Cmd){ this.addToCmd(item);}} return (T) this;
    }
    public String getContainer(){
    return this.Container;
    }
    public T withContainer( String Container){
    this.Container=Container; return (T) this;
    }
    public Boolean isDetach(){
    return this.Detach;
    }
    public T withDetach( Boolean Detach){
    this.Detach=Detach; return (T) this;
    }
    public Boolean isPrivileged(){
    return this.Privileged;
    }
    public T withPrivileged( Boolean Privileged){
    this.Privileged=Privileged; return (T) this;
    }
    public Boolean isTty(){
    return this.Tty;
    }
    public T withTty( Boolean Tty){
    this.Tty=Tty; return (T) this;
    }
    public String getUser(){
    return this.User;
    }
    public T withUser( String User){
    this.User=User; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
ExecConfigFluentImpl that = (ExecConfigFluentImpl) o;
if (AttachStderr != null ? !AttachStderr.equals(that.AttachStderr) :that.AttachStderr != null) return false;
if (AttachStdin != null ? !AttachStdin.equals(that.AttachStdin) :that.AttachStdin != null) return false;
if (AttachStdout != null ? !AttachStdout.equals(that.AttachStdout) :that.AttachStdout != null) return false;
if (Cmd != null ? !Cmd.equals(that.Cmd) :that.Cmd != null) return false;
if (Container != null ? !Container.equals(that.Container) :that.Container != null) return false;
if (Detach != null ? !Detach.equals(that.Detach) :that.Detach != null) return false;
if (Privileged != null ? !Privileged.equals(that.Privileged) :that.Privileged != null) return false;
if (Tty != null ? !Tty.equals(that.Tty) :that.Tty != null) return false;
if (User != null ? !User.equals(that.User) :that.User != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }



}
