package io.fabric8.docker.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.Map;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.util.AbstractMap;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.Builder;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.builder.Fluent;

public class CPUStatsBuilder extends CPUStatsFluentImpl<CPUStatsBuilder> implements VisitableBuilder<CPUStats,CPUStatsBuilder>{

     CPUStatsFluent<?> fluent;
public CPUStatsBuilder(){
    this(new CPUStats());
}
public CPUStatsBuilder( CPUStatsFluent<?> fluent ){
    this(fluent, new CPUStats());
}
public CPUStatsBuilder( CPUStatsFluent<?> fluent , CPUStats instance ){
    this.fluent = fluent; fluent.withCpuUsage(instance.getCpuUsage()); fluent.withSystemCpuUsage(instance.getSystemCpuUsage()); fluent.withThrottlingData(instance.getThrottlingData()); 
}
public CPUStatsBuilder( CPUStats instance ){
    this.fluent = this; this.withCpuUsage(instance.getCpuUsage()); this.withSystemCpuUsage(instance.getSystemCpuUsage()); this.withThrottlingData(instance.getThrottlingData()); 
}

public EditableCPUStats build(){
    EditableCPUStats buildable = new EditableCPUStats(fluent.getCpuUsage(),fluent.getSystemCpuUsage(),fluent.getThrottlingData());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
CPUStatsBuilder that = (CPUStatsBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
