/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.EditableThrottlingData;
import io.fabric8.docker.api.model.ThrottlingData;
import io.fabric8.docker.api.model.ThrottlingDataFluent;
import io.fabric8.docker.api.model.ThrottlingDataFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ThrottlingDataBuilder
extends ThrottlingDataFluentImpl<ThrottlingDataBuilder>
implements VisitableBuilder<ThrottlingData, ThrottlingDataBuilder> {
    ThrottlingDataFluent<?> fluent;

    public ThrottlingDataBuilder() {
        this(new ThrottlingData());
    }

    public ThrottlingDataBuilder(ThrottlingDataFluent<?> fluent) {
        this(fluent, new ThrottlingData());
    }

    public ThrottlingDataBuilder(ThrottlingDataFluent<?> fluent, ThrottlingData instance) {
        this.fluent = fluent;
        fluent.withPeriods(instance.getPeriods());
        fluent.withThrottledPeriods(instance.getThrottledPeriods());
        fluent.withThrottledTime(instance.getThrottledTime());
    }

    public ThrottlingDataBuilder(ThrottlingData instance) {
        this.fluent = this;
        this.withPeriods(instance.getPeriods());
        this.withThrottledPeriods(instance.getThrottledPeriods());
        this.withThrottledTime(instance.getThrottledTime());
    }

    @Override
    public EditableThrottlingData build() {
        EditableThrottlingData buildable = new EditableThrottlingData(this.fluent.getPeriods(), this.fluent.getThrottledPeriods(), this.fluent.getThrottledTime());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ThrottlingDataBuilder that = (ThrottlingDataBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

