/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.BlkioStats;
import io.fabric8.docker.api.model.BlkioStatsBuilder;
import io.fabric8.docker.api.model.BlkioStatsFluentImpl;
import io.fabric8.docker.api.model.CPUStats;
import io.fabric8.docker.api.model.CPUStatsBuilder;
import io.fabric8.docker.api.model.CPUStatsFluentImpl;
import io.fabric8.docker.api.model.MemoryStats;
import io.fabric8.docker.api.model.MemoryStatsBuilder;
import io.fabric8.docker.api.model.MemoryStatsFluentImpl;
import io.fabric8.docker.api.model.Stats;
import io.fabric8.docker.api.model.StatsFluent;
import java.util.HashMap;
import java.util.Map;

public class StatsFluentImpl<T extends StatsFluent<T>>
extends BaseFluent<T>
implements StatsFluent<T> {
    VisitableBuilder<BlkioStats, ?> blkioStats;
    VisitableBuilder<CPUStats, ?> cpuStats;
    VisitableBuilder<MemoryStats, ?> memoryStats;
    VisitableBuilder<CPUStats, ?> precpuStats;
    String read;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public StatsFluentImpl() {
    }

    public StatsFluentImpl(Stats instance) {
        this.withBlkioStats(instance.getBlkioStats());
        this.withCpuStats(instance.getCpuStats());
        this.withMemoryStats(instance.getMemoryStats());
        this.withPrecpuStats(instance.getPrecpuStats());
        this.withRead(instance.getRead());
    }

    @Override
    public BlkioStats getBlkioStats() {
        return this.blkioStats != null ? (BlkioStats)this.blkioStats.build() : null;
    }

    @Override
    public T withBlkioStats(BlkioStats blkioStats) {
        if (blkioStats != null) {
            this.blkioStats = new BlkioStatsBuilder(blkioStats);
            this._visitables.add(this.blkioStats);
        }
        return (T)this;
    }

    @Override
    public StatsFluent.BlkioStatsNested<T> withNewBlkioStats() {
        return new BlkioStatsNestedImpl();
    }

    @Override
    public StatsFluent.BlkioStatsNested<T> withNewBlkioStatsLike(BlkioStats item) {
        return new BlkioStatsNestedImpl(item);
    }

    @Override
    public StatsFluent.BlkioStatsNested<T> editBlkioStats() {
        return this.withNewBlkioStatsLike(this.getBlkioStats());
    }

    @Override
    public CPUStats getCpuStats() {
        return this.cpuStats != null ? (CPUStats)this.cpuStats.build() : null;
    }

    @Override
    public T withCpuStats(CPUStats cpuStats) {
        if (cpuStats != null) {
            this.cpuStats = new CPUStatsBuilder(cpuStats);
            this._visitables.add(this.cpuStats);
        }
        return (T)this;
    }

    @Override
    public StatsFluent.CpuStatsNested<T> withNewCpuStats() {
        return new CpuStatsNestedImpl();
    }

    @Override
    public StatsFluent.CpuStatsNested<T> withNewCpuStatsLike(CPUStats item) {
        return new CpuStatsNestedImpl(item);
    }

    @Override
    public StatsFluent.CpuStatsNested<T> editCpuStats() {
        return this.withNewCpuStatsLike(this.getCpuStats());
    }

    @Override
    public MemoryStats getMemoryStats() {
        return this.memoryStats != null ? (MemoryStats)this.memoryStats.build() : null;
    }

    @Override
    public T withMemoryStats(MemoryStats memoryStats) {
        if (memoryStats != null) {
            this.memoryStats = new MemoryStatsBuilder(memoryStats);
            this._visitables.add(this.memoryStats);
        }
        return (T)this;
    }

    @Override
    public StatsFluent.MemoryStatsNested<T> withNewMemoryStats() {
        return new MemoryStatsNestedImpl();
    }

    @Override
    public StatsFluent.MemoryStatsNested<T> withNewMemoryStatsLike(MemoryStats item) {
        return new MemoryStatsNestedImpl(item);
    }

    @Override
    public StatsFluent.MemoryStatsNested<T> editMemoryStats() {
        return this.withNewMemoryStatsLike(this.getMemoryStats());
    }

    @Override
    public CPUStats getPrecpuStats() {
        return this.precpuStats != null ? (CPUStats)this.precpuStats.build() : null;
    }

    @Override
    public T withPrecpuStats(CPUStats precpuStats) {
        if (precpuStats != null) {
            this.precpuStats = new CPUStatsBuilder(precpuStats);
            this._visitables.add(this.precpuStats);
        }
        return (T)this;
    }

    @Override
    public StatsFluent.PrecpuStatsNested<T> withNewPrecpuStats() {
        return new PrecpuStatsNestedImpl();
    }

    @Override
    public StatsFluent.PrecpuStatsNested<T> withNewPrecpuStatsLike(CPUStats item) {
        return new PrecpuStatsNestedImpl(item);
    }

    @Override
    public StatsFluent.PrecpuStatsNested<T> editPrecpuStats() {
        return this.withNewPrecpuStatsLike(this.getPrecpuStats());
    }

    @Override
    public String getRead() {
        return this.read;
    }

    @Override
    public T withRead(String read) {
        this.read = read;
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.additionalProperties.remove(key);
            }
        }
        return (T)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatsFluentImpl that = (StatsFluentImpl)o;
        if (this.blkioStats != null ? !this.blkioStats.equals(that.blkioStats) : that.blkioStats != null) {
            return false;
        }
        if (this.cpuStats != null ? !this.cpuStats.equals(that.cpuStats) : that.cpuStats != null) {
            return false;
        }
        if (this.memoryStats != null ? !this.memoryStats.equals(that.memoryStats) : that.memoryStats != null) {
            return false;
        }
        if (this.precpuStats != null ? !this.precpuStats.equals(that.precpuStats) : that.precpuStats != null) {
            return false;
        }
        if (this.read != null ? !this.read.equals(that.read) : that.read != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class PrecpuStatsNestedImpl<N>
    extends CPUStatsFluentImpl<StatsFluent.PrecpuStatsNested<N>>
    implements StatsFluent.PrecpuStatsNested<N> {
        private final CPUStatsBuilder builder;

        PrecpuStatsNestedImpl() {
            this.builder = new CPUStatsBuilder(this);
        }

        PrecpuStatsNestedImpl(CPUStats item) {
            this.builder = new CPUStatsBuilder(this, item);
        }

        @Override
        public N endPrecpuStats() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)StatsFluentImpl.this.withPrecpuStats(this.builder.build());
        }
    }

    public class MemoryStatsNestedImpl<N>
    extends MemoryStatsFluentImpl<StatsFluent.MemoryStatsNested<N>>
    implements StatsFluent.MemoryStatsNested<N> {
        private final MemoryStatsBuilder builder;

        MemoryStatsNestedImpl() {
            this.builder = new MemoryStatsBuilder(this);
        }

        MemoryStatsNestedImpl(MemoryStats item) {
            this.builder = new MemoryStatsBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)StatsFluentImpl.this.withMemoryStats(this.builder.build());
        }

        @Override
        public N endMemoryStats() {
            return this.and();
        }
    }

    public class CpuStatsNestedImpl<N>
    extends CPUStatsFluentImpl<StatsFluent.CpuStatsNested<N>>
    implements StatsFluent.CpuStatsNested<N> {
        private final CPUStatsBuilder builder;

        CpuStatsNestedImpl() {
            this.builder = new CPUStatsBuilder(this);
        }

        CpuStatsNestedImpl(CPUStats item) {
            this.builder = new CPUStatsBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)StatsFluentImpl.this.withCpuStats(this.builder.build());
        }

        @Override
        public N endCpuStats() {
            return this.and();
        }
    }

    public class BlkioStatsNestedImpl<N>
    extends BlkioStatsFluentImpl<StatsFluent.BlkioStatsNested<N>>
    implements StatsFluent.BlkioStatsNested<N> {
        private final BlkioStatsBuilder builder;

        BlkioStatsNestedImpl() {
            this.builder = new BlkioStatsBuilder(this);
        }

        BlkioStatsNestedImpl(BlkioStats item) {
            this.builder = new BlkioStatsBuilder(this, item);
        }

        @Override
        public N endBlkioStats() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)StatsFluentImpl.this.withBlkioStats(this.builder.build());
        }
    }
}

